/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.httpproxy;

import it.geosolutions.httpproxy.HttpErrorException;
import it.geosolutions.httpproxy.ProxyCallback;
import it.geosolutions.httpproxy.ProxyConfig;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class MethodsChecker
implements ProxyCallback {
    ProxyConfig config;

    public MethodsChecker(ProxyConfig config) {
        this.config = config;
    }

    @Override
    public void onRequest(HttpServletRequest request, HttpServletResponse response, URL url) throws IOException {
        String method;
        Set<String> methods = this.config.getMethodsWhitelist();
        if (methods != null && methods.size() > 0 && !methods.contains(method = request.getMethod())) {
            throw new HttpErrorException(403, "HTTP Method " + method + " is not among the ones allowed for this proxy");
        }
    }

    @Override
    public void onRemoteResponse(HttpRequestBase method) throws IOException {
    }

    @Override
    public void onFinish() throws IOException {
    }
}

