/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.httpproxy;

import it.geosolutions.httpproxy.Utils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

final class ProxyConfig {
    private static final Logger LOGGER = Logger.getLogger(ProxyConfig.class.toString());
    private Set<String> hostnameWhitelist = new HashSet<String>();
    private Set<String> mimetypeWhitelist = new HashSet<String>();
    private Set<String> reqtypeWhitelist = new HashSet<String>();
    private Set<String> methodsWhitelist = new HashSet<String>();
    private Set<String> hostsWhitelist = new HashSet<String>();
    private ServletContext context;
    private String propertiesFilePath;
    private int soTimeout = 30000;
    private int connectionTimeout = 30000;
    private int maxTotalConnections = 60;
    private int defaultMaxConnectionsPerHost = 6;
    private int defaultStreamByteSize = 1024;

    public ProxyConfig(ServletContext context, String propertiesFilePath) {
        this.context = context;
        this.propertiesFilePath = propertiesFilePath;
        this.configProxy();
    }

    private void configProxy() {
        Properties props = this.propertiesLoader();
        if (props != null) {
            Set<String> p = Utils.parseWhiteList(props.getProperty("hostnameWhitelist"));
            if (p != null) {
                this.setHostnameWhitelist(p);
            }
            if ((p = Utils.parseWhiteList(props.getProperty("mimetypeWhitelist"))) != null) {
                this.setMimetypeWhitelist(p);
            }
            if ((p = Utils.parseWhiteList(props.getProperty("methodsWhitelist"))) != null) {
                this.setMethodsWhitelist(p);
            }
            if ((p = Utils.parseWhiteList(props.getProperty("hostsWhitelist"))) != null) {
                this.setHostsWhitelist(p);
            }
            HashSet<String> rt = new HashSet<String>();
            String s = props.getProperty("reqtypeWhitelist.capabilities");
            if (s != null) {
                rt.add(s);
            }
            if ((s = props.getProperty("reqtypeWhitelist.geostore")) != null) {
                rt.add(s);
            }
            if ((s = props.getProperty("reqtypeWhitelist.csw")) != null) {
                rt.add(s);
            }
            if ((s = props.getProperty("reqtypeWhitelist.featureinfo")) != null) {
                rt.add(s);
            }
            if ((s = props.getProperty("reqtypeWhitelist.generic")) != null) {
                rt.add(s);
            }
            this.setReqtypeWhitelist(rt);
            try {
                String bytesSize = props.getProperty("defaultStreamByteSize");
                this.setDefaultStreamByteSize(bytesSize != null ? Integer.parseInt(bytesSize) : this.defaultStreamByteSize);
                String timeout = props.getProperty("timeout");
                this.setSoTimeout(timeout != null ? Integer.parseInt(timeout) : this.soTimeout);
                String conn_timeout = props.getProperty("connection_timeout");
                this.setConnectionTimeout(conn_timeout != null ? Integer.parseInt(conn_timeout) : this.connectionTimeout);
                String max_conn = props.getProperty("max_total_connections");
                this.setMaxTotalConnections(max_conn != null ? Integer.parseInt(max_conn) : this.maxTotalConnections);
                String def_conn_host = props.getProperty("default_max_connections_per_host");
                this.setMaxTotalConnections(def_conn_host != null ? Integer.parseInt(def_conn_host) : this.defaultMaxConnectionsPerHost);
            }
            catch (NumberFormatException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Error parsing the proxy properties file using default", e);
                }
                this.setSoTimeout(this.soTimeout);
                this.setConnectionTimeout(this.connectionTimeout);
                this.setMaxTotalConnections(this.maxTotalConnections);
                this.setMaxTotalConnections(this.defaultMaxConnectionsPerHost);
                this.setDefaultStreamByteSize(this.defaultStreamByteSize);
            }
        }
    }

    public Properties propertiesLoader() {
        Properties props = new Properties();
        for (String path : this.propertiesFilePath.split(",")) {
            this.mergePropertiesConfig(path, props);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergePropertiesConfig(String path, Properties properties) {
        InputStream inputStream;
        block17: {
            inputStream = ProxyConfig.class.getResourceAsStream(path);
            if (inputStream == null) {
                try {
                    inputStream = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block17;
                    LOGGER.log(Level.WARNING, "The properties file " + path + " cannot be found");
                }
            }
        }
        if (inputStream != null) {
            Properties props = new Properties();
            try {
                props.load(inputStream);
                properties.putAll((Map<?, ?>)props);
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Error loading the proxy properties file from " + path, e);
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getDefaultMaxConnectionsPerHost() {
        return this.defaultMaxConnectionsPerHost;
    }

    public void setDefaultMaxConnectionsPerHost(int defaultMaxConnectionsPerHost) {
        this.defaultMaxConnectionsPerHost = defaultMaxConnectionsPerHost;
    }

    public Set<String> getHostnameWhitelist() {
        Set<String> set;
        Properties props = this.propertiesLoader();
        if (props != null && (set = Utils.parseWhiteList(props.getProperty("hostnameWhitelist"))) != null) {
            this.setHostnameWhitelist(set);
        }
        return this.hostnameWhitelist;
    }

    public void setHostnameWhitelist(Set<String> hostnameWhitelist) {
        this.hostnameWhitelist = hostnameWhitelist;
    }

    public Set<String> getMimetypeWhitelist() {
        Set<String> set;
        Properties props = this.propertiesLoader();
        if (props != null && (set = Utils.parseWhiteList(props.getProperty("mimetypeWhitelist"))) != null) {
            this.setMimetypeWhitelist(set);
        }
        return this.mimetypeWhitelist;
    }

    public void setMimetypeWhitelist(Set<String> mimetypeWhitelist) {
        this.mimetypeWhitelist = mimetypeWhitelist;
    }

    public Set<String> getReqtypeWhitelist() {
        Properties props = this.propertiesLoader();
        if (props != null) {
            HashSet<String> rt = new HashSet<String>();
            String s = props.getProperty("reqtypeWhitelist.capabilities");
            if (s != null) {
                rt.add(s);
            }
            if ((s = props.getProperty("reqtypeWhitelist.geostore")) != null) {
                rt.add(s);
            }
            if ((s = props.getProperty("reqtypeWhitelist.csw")) != null) {
                rt.add(s);
            }
            if ((s = props.getProperty("reqtypeWhitelist.featureinfo")) != null) {
                rt.add(s);
            }
            if ((s = props.getProperty("reqtypeWhitelist.generic")) != null) {
                rt.add(s);
            }
            this.setReqtypeWhitelist(rt);
        }
        return this.reqtypeWhitelist;
    }

    public void setReqtypeWhitelist(Set<String> reqtypeWhitelist) {
        this.reqtypeWhitelist = reqtypeWhitelist;
    }

    public Set<String> getMethodsWhitelist() {
        Set<String> set;
        Properties props = this.propertiesLoader();
        if (props != null && (set = Utils.parseWhiteList(props.getProperty("methodsWhitelist"))) != null) {
            this.setMethodsWhitelist(set);
        }
        return this.methodsWhitelist;
    }

    public void setMethodsWhitelist(Set<String> methodsWhitelist) {
        this.methodsWhitelist = methodsWhitelist;
    }

    public Set<String> getHostsWhitelist() {
        Set<String> set;
        Properties props = this.propertiesLoader();
        if (props != null && (set = Utils.parseWhiteList(props.getProperty("hostsWhitelist"))) != null) {
            this.setHostsWhitelist(set);
        }
        return this.hostsWhitelist;
    }

    public void setHostsWhitelist(Set<String> hostsWhitelist) {
        this.hostsWhitelist = hostsWhitelist;
    }

    public ServletContext getContext() {
        return this.context;
    }

    public void setContext(ServletContext context) {
        this.context = context;
    }

    public String getPropertiesFilePath() {
        return this.propertiesFilePath;
    }

    public void setPropertiesFilePath(String propertiesFilePath) {
        this.propertiesFilePath = propertiesFilePath;
    }

    public int getDefaultStreamByteSize() {
        return this.defaultStreamByteSize;
    }

    public void setDefaultStreamByteSize(int defaultStreamByteSize) {
        this.defaultStreamByteSize = defaultStreamByteSize;
    }
}

