/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import org.pvalsecc.concurrent.SynchronousTarget;

public class SynchronousSimpleTarget
extends SynchronousTarget {
    private AtomicInteger count = new AtomicInteger(0);
    private AtomicInteger target = new AtomicInteger(-1);

    public SynchronousSimpleTarget(String name, Runnable completedCallback) {
        super(completedCallback, name);
    }

    @Override
    protected boolean isVirgin() {
        return this.count.get() == 0;
    }

    public int addDone(int nb) {
        int currentCount = this.count.addAndGet(nb);
        int currentTarget = this.target.get();
        if (currentTarget >= 0) {
            if (currentCount == currentTarget) {
                this.call();
            } else if (currentCount > currentTarget) {
                throw new RuntimeException("Job overtook its target [" + this.getName() + "]");
            }
        }
        return currentCount;
    }

    @Override
    public synchronized void setTarget(int target) {
        if (this.target.get() >= 0) {
            throw new RuntimeException("Target already set");
        }
        this.target.set(target);
        if (this.count.get() == target) {
            this.call();
        }
    }

    public int getCount() {
        return this.count.get();
    }

    public boolean isTargetKnown() {
        return this.target.get() >= 0;
    }

    public int getTarget() {
        return this.target.get();
    }
}

