/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.ParallelMapTileLoader;
import org.mapfish.print.map.readers.MapReader;
import org.mapfish.print.map.readers.MapReaderFactory;
import org.mapfish.print.map.readers.TileCacheLayerInfo;
import org.mapfish.print.map.readers.TileableMapReader;
import org.mapfish.print.map.readers.WMTSLayerInfo;
import org.mapfish.print.map.renderers.TileRenderer;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class WMTSMapReader
extends TileableMapReader {
    protected final String layer;
    private final float opacity;
    private final String version;
    private final String requestEncoding;
    private final PJsonArray tileOrigin;
    private final String style;
    private final PJsonArray dimensions;
    private final PJsonObject dimensionsParams;
    private final String matrixSet;
    private final Integer zoomOffset;
    private final PJsonArray matrixIds;
    private final String formatSuffix;
    private final String format;
    private PJsonObject matrix;

    private WMTSMapReader(String layer, RenderingContext context, PJsonObject params) {
        super(context, params);
        this.layer = layer;
        PJsonArray maxExtent = params.optJSONArray("tileFullExtent", params.optJSONArray("maxExtent"));
        PJsonArray tileSize = params.optJSONArray("tileSize");
        this.opacity = params.optFloat("opacity", 1.0f).floatValue();
        this.version = params.getString("version");
        this.requestEncoding = params.getString("requestEncoding");
        this.tileOrigin = params.optJSONArray("tileOrigin");
        this.style = params.getString("style");
        this.dimensions = params.optJSONArray("dimensions");
        this.dimensionsParams = params.optJSONObject("params");
        this.matrixSet = params.getString("matrixSet");
        this.zoomOffset = params.optInt("zoomOffset");
        this.matrixIds = params.optJSONArray("matrixIds");
        this.formatSuffix = params.optString("formatSuffix");
        this.format = params.optString("format");
        if (this.matrixIds == null) {
            this.tileCacheLayerInfo = new WMTSLayerInfo(params.getJSONArray("resolutions"), tileSize.getInt(0), tileSize.getInt(1), maxExtent.getFloat(0), maxExtent.getFloat(1), maxExtent.getFloat(2), maxExtent.getFloat(3), this.formatSuffix);
        }
    }

    @Override
    protected TileRenderer.Format getFormat() {
        return TileRenderer.Format.BITMAP;
    }

    @Override
    protected void addCommonQueryParams(Map<String, List<String>> result, Transformer transformer, String srs, boolean first) {
    }

    @Override
    protected void renderTiles(TileRenderer formater, Transformer transformer, URI commonUri, ParallelMapTileLoader parallelMapTileLoader) throws IOException, URISyntaxException {
        if (this.matrixIds != null) {
            float diff = Float.POSITIVE_INFINITY;
            float targetResolution = transformer.getGeoW() / transformer.getStraightBitmapW();
            for (int i = 0; i < this.matrixIds.size(); ++i) {
                PJsonObject matrixId = this.matrixIds.getJSONObject(i);
                float resolution = matrixId.getFloat("resolution");
                float delta = Math.abs(1.0f - resolution / targetResolution);
                if (!(delta < diff)) continue;
                diff = delta;
                this.matrix = matrixId;
            }
            float resolution = this.matrix.getFloat("resolution");
            PJsonArray tileSize = this.matrix.getJSONArray("tileSize");
            PJsonArray topLeftCorner = this.matrix.getJSONArray("topLeftCorner");
            PJsonArray matrixSize = this.matrix.getJSONArray("matrixSize");
            this.tileCacheLayerInfo = new TileCacheLayerInfo(String.valueOf(resolution), tileSize.getInt(0), tileSize.getInt(1), topLeftCorner.getFloat(0), topLeftCorner.getFloat(1) - (float)(tileSize.getInt(1) * matrixSize.getInt(1)) * resolution, topLeftCorner.getFloat(0) + (float)(tileSize.getInt(0) * matrixSize.getInt(0)) * resolution, topLeftCorner.getFloat(1), this.format);
        }
        super.renderTiles(formater, transformer, commonUri, parallelMapTileLoader);
    }

    @Override
    protected URI getTileUri(URI commonUri, Transformer transformer, float minGeoX, float minGeoY, float maxGeoX, float maxGeoY, long w, long h) throws URISyntaxException, UnsupportedEncodingException {
        if (this.matrixIds != null) {
            PJsonArray topLeftCorner = this.matrix.getJSONArray("topLeftCorner");
            float factor = 1.0f / (this.matrix.getFloat("resolution") * (float)w);
            int row = Math.round((topLeftCorner.getFloat(1) - maxGeoY) * factor);
            int col = Math.round((minGeoX - topLeftCorner.getFloat(0)) * factor);
            if ("REST".equals(this.requestEncoding)) {
                String path = commonUri.getPath();
                for (int i = 0; i < this.dimensions.size(); ++i) {
                    String d = this.dimensions.getString(i);
                    path = path.replace("{" + d + "}", this.dimensionsParams.getString(d.toUpperCase()));
                }
                path = path.replace("{TileMatrixSet}", this.matrixSet);
                path = path.replace("{TileMatrix}", this.matrix.getString("identifier"));
                path = path.replace("{TileRow}", String.valueOf(row));
                path = path.replace("{TileCol}", String.valueOf(col));
                return new URI(commonUri.getScheme(), commonUri.getUserInfo(), commonUri.getHost(), commonUri.getPort(), path, commonUri.getQuery(), commonUri.getFragment());
            }
            String query = "SERVICE=WMTS";
            query = query + "&REQUEST=GetTile";
            query = query + "&VERSION=" + this.version;
            query = query + "&LAYER=" + this.layer;
            query = query + "&STYLE=" + this.style;
            query = query + "&TILEMATRIXSET=" + this.matrixSet;
            query = query + "&TILEMATRIX=" + this.matrix.getString("identifier");
            query = query + "&TILEROW=" + row;
            query = query + "&TILECOL=" + col;
            query = query + "&FORMAT=" + this.format;
            if (this.dimensions != null) {
                for (int i = 0; i < this.dimensions.size(); ++i) {
                    String d = this.dimensions.getString(i);
                    query = query + "&" + d + "=" + this.dimensionsParams.getString(d.toUpperCase());
                }
            }
            return new URI(commonUri.getScheme(), commonUri.getUserInfo(), commonUri.getHost(), commonUri.getPort(), commonUri.getPath(), query, commonUri.getFragment());
        }
        float targetResolution = (maxGeoX - minGeoX) / (float)w;
        TileCacheLayerInfo.ResolutionInfo resolution = this.tileCacheLayerInfo.getNearestResolution(targetResolution);
        int col = (int)Math.round(Math.floor(((maxGeoX + minGeoX) / 2.0f - this.tileOrigin.getFloat(0)) / (resolution.value * (float)w)));
        int row = (int)Math.round(Math.floor((this.tileOrigin.getFloat(1) - (maxGeoY + minGeoY) / 2.0f) / (resolution.value * (float)h)));
        StringBuilder path = new StringBuilder();
        if (!commonUri.getPath().endsWith("/")) {
            path.append('/');
        }
        if (this.requestEncoding.compareTo("REST") == 0) {
            path.append(this.version);
            path.append('/').append(this.layer);
            path.append('/').append(this.style);
            if (this.dimensions != null) {
                for (int i = 0; i < this.dimensions.size(); ++i) {
                    path.append('/').append(this.dimensionsParams.getString(this.dimensions.getString(i)));
                }
            }
            path.append('/').append(this.matrixSet);
            path.append('/').append(resolution.index + this.zoomOffset);
            path.append('/').append(row);
            path.append('/').append(col);
            path.append('.').append(this.tileCacheLayerInfo.getExtension());
            return new URI(commonUri.getScheme(), commonUri.getUserInfo(), commonUri.getHost(), commonUri.getPort(), commonUri.getPath() + path, commonUri.getQuery(), commonUri.getFragment());
        }
        String query = "SERVICE=WMTS";
        query = query + "&REQUEST=GetTile";
        query = query + "&VERSION=" + this.version;
        query = query + "&LAYER=" + this.layer;
        query = query + "&STYLE=" + this.style;
        query = query + "&TILEMATRIXSET=" + this.matrixSet;
        query = query + "&TILEMATRIX=" + (resolution.index + this.zoomOffset);
        query = query + "&TILEROW=" + row;
        query = query + "&TILECOL=" + col;
        query = query + "&FORMAT=" + (this.formatSuffix.equals("png") ? "image/png" : "image/jpeg");
        if (this.dimensions != null) {
            for (int i = 0; i < this.dimensions.size(); ++i) {
                String d = this.dimensions.getString(i);
                query = query + "&" + d + "=" + this.dimensionsParams.getString(d.toUpperCase());
            }
        }
        return new URI(commonUri.getScheme(), commonUri.getUserInfo(), commonUri.getHost(), commonUri.getPort(), commonUri.getPath(), query, commonUri.getFragment());
    }

    @Override
    public boolean testMerge(MapReader other) {
        return false;
    }

    @Override
    public boolean canMerge(MapReader other) {
        return false;
    }

    @Override
    public String toString() {
        return this.layer;
    }

    public static class Factory
    implements MapReaderFactory {
        @Override
        public List<? extends MapReader> create(String type, RenderingContext context, PJsonObject params) {
            return Collections.singletonList(new WMTSMapReader(params.getString("layer"), context, params));
        }
    }
}

