/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.ParallelMapTileLoader;
import org.mapfish.print.map.readers.HTTPMapReader;
import org.mapfish.print.map.readers.KaMapCacheMapReader;
import org.mapfish.print.map.readers.KaMapMapReader;
import org.mapfish.print.map.readers.TileCacheLayerInfo;
import org.mapfish.print.map.renderers.TileRenderer;
import org.mapfish.print.utils.PJsonObject;

public abstract class TileableMapReader
extends HTTPMapReader {
    protected TileCacheLayerInfo tileCacheLayerInfo;

    protected TileableMapReader(RenderingContext context, PJsonObject params) {
        super(context, params);
    }

    @Override
    protected void renderTiles(TileRenderer formater, Transformer transformer, URI commonUri, ParallelMapTileLoader parallelMapTileLoader) throws IOException, URISyntaxException {
        float offsetY;
        float offsetX;
        long bitmapTileH;
        long bitmapTileW;
        ArrayList<URI> urls = new ArrayList<URI>(1);
        int nbTilesW = 0;
        float minGeoX = transformer.getRotatedMinGeoX();
        float minGeoY = transformer.getRotatedMinGeoY();
        float maxGeoX = transformer.getRotatedMaxGeoX();
        float maxGeoY = transformer.getRotatedMaxGeoY();
        if (this.tileCacheLayerInfo != null) {
            float tileMinGeoY;
            float tileMinGeoX;
            if ((transformer = this.fixTiledTransformer(transformer)) == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Resolution out of bounds.");
                }
                urls.add(null);
            }
            bitmapTileW = this.tileCacheLayerInfo.getWidth();
            bitmapTileH = this.tileCacheLayerInfo.getHeight();
            float tileGeoWidth = transformer.getResolution() * (float)bitmapTileW;
            float tileGeoHeight = transformer.getResolution() * (float)bitmapTileH;
            if (this instanceof KaMapCacheMapReader || this instanceof KaMapMapReader) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Kamap min geo x and y calculation used");
                }
                tileMinGeoX = (float)(Math.floor(minGeoX / tileGeoWidth) * (double)tileGeoWidth);
                tileMinGeoY = (float)(Math.floor(minGeoY / tileGeoHeight) * (double)tileGeoHeight);
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Default min geo x and y calculation used");
                }
                tileMinGeoX = (float)((double)this.tileCacheLayerInfo.getOriginX() + Math.floor((minGeoX - this.tileCacheLayerInfo.getOriginX()) / tileGeoWidth) * (double)tileGeoWidth);
                tileMinGeoY = (float)((double)this.tileCacheLayerInfo.getOriginY() + Math.floor((minGeoY - this.tileCacheLayerInfo.getOriginY()) / tileGeoHeight) * (double)tileGeoHeight);
            }
            offsetX = (minGeoX - tileMinGeoX) / transformer.getResolution();
            offsetY = (minGeoY - tileMinGeoY) / transformer.getResolution();
            for (float geoY = tileMinGeoY; geoY < maxGeoY; geoY += tileGeoHeight) {
                nbTilesW = 0;
                for (float geoX = tileMinGeoX; geoX < maxGeoX; geoX += tileGeoWidth) {
                    ++nbTilesW;
                    if (this.tileCacheLayerInfo.isVisible(geoX, geoY, geoX + tileGeoWidth, geoY + tileGeoHeight)) {
                        urls.add(this.getTileUri(commonUri, transformer, geoX, geoY, geoX + tileGeoWidth, geoY + tileGeoHeight, bitmapTileW, bitmapTileH));
                        continue;
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Tile out of bounds: " + this.getTileUri(commonUri, transformer, geoX, geoY, geoX + tileGeoWidth, geoY + tileGeoHeight, bitmapTileW, bitmapTileH)));
                    }
                    urls.add(null);
                }
            }
        } else {
            nbTilesW = 1;
            offsetX = 0.0f;
            offsetY = 0.0f;
            bitmapTileW = transformer.getRotatedBitmapW();
            bitmapTileH = transformer.getRotatedBitmapH();
            urls.add(this.getTileUri(commonUri, transformer, minGeoX, minGeoY, maxGeoX, maxGeoY, bitmapTileW, bitmapTileH));
        }
        formater.render(transformer, urls, parallelMapTileLoader, this.context, this.opacity, nbTilesW, offsetX, offsetY, bitmapTileW, bitmapTileH);
    }

    private Transformer fixTiledTransformer(Transformer transformer) {
        float resolution;
        if (this.context.getCurrentPageParams().has("clientResolution")) {
            float clientResolution = this.context.getCurrentPageParams().getFloat("clientResolution");
            boolean hasServerResolution = false;
            for (float serverResolution : this.tileCacheLayerInfo.getResolutions()) {
                if (serverResolution != clientResolution) continue;
                hasServerResolution = true;
            }
            if (!hasServerResolution) {
                return null;
            }
            resolution = clientResolution;
        } else {
            float targetResolution = transformer.getGeoW() / transformer.getStraightBitmapW();
            TileCacheLayerInfo.ResolutionInfo resolutionInfo = this.tileCacheLayerInfo.getNearestResolution(targetResolution);
            resolution = resolutionInfo.value;
        }
        transformer = transformer.clone();
        transformer.setResolution(resolution);
        return transformer;
    }

    protected abstract URI getTileUri(URI var1, Transformer var2, float var3, float var4, float var5, float var6, long var7, long var9) throws URISyntaxException, UnsupportedEncodingException;
}

