/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.readers.MapReader;
import org.mapfish.print.map.readers.MapReaderFactory;
import org.mapfish.print.map.readers.TileCacheLayerInfo;
import org.mapfish.print.map.readers.TileableMapReader;
import org.mapfish.print.map.renderers.TileRenderer;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class TileCacheMapReader
extends TileableMapReader {
    private final String layer;

    private TileCacheMapReader(String layer, RenderingContext context, PJsonObject params) {
        super(context, params);
        this.layer = layer;
        PJsonArray maxExtent = params.getJSONArray("maxExtent");
        PJsonArray tileSize = params.getJSONArray("tileSize");
        this.tileCacheLayerInfo = new TileCacheLayerInfo(params.getJSONArray("resolutions"), tileSize.getInt(0), tileSize.getInt(1), maxExtent.getFloat(0), maxExtent.getFloat(1), maxExtent.getFloat(2), maxExtent.getFloat(3), params.getString("extension"));
    }

    @Override
    protected TileRenderer.Format getFormat() {
        return TileRenderer.Format.BITMAP;
    }

    @Override
    protected void addCommonQueryParams(Map<String, List<String>> result, Transformer transformer, String srs, boolean first) {
    }

    @Override
    protected URI getTileUri(URI commonUri, Transformer transformer, float minGeoX, float minGeoY, float maxGeoX, float maxGeoY, long w, long h) throws URISyntaxException, UnsupportedEncodingException {
        float targetResolution = (maxGeoX - minGeoX) / (float)w;
        TileCacheLayerInfo.ResolutionInfo resolution = this.tileCacheLayerInfo.getNearestResolution(targetResolution);
        int tileX = Math.round((minGeoX - this.tileCacheLayerInfo.getMinX()) / (resolution.value * (float)w));
        int tileY = Math.round((minGeoY - this.tileCacheLayerInfo.getMinY()) / (resolution.value * (float)h));
        StringBuilder path = new StringBuilder();
        if (!commonUri.getPath().endsWith("/")) {
            path.append('/');
        }
        path.append(this.layer);
        path.append('/').append(String.format("%02d", resolution.index));
        path.append('/').append(String.format("%03d", tileX / 1000000 % 1000));
        path.append('/').append(String.format("%03d", tileX / 1000 % 1000));
        path.append('/').append(String.format("%03d", tileX % 1000));
        path.append('/').append(String.format("%03d", tileY / 1000000 % 1000));
        path.append('/').append(String.format("%03d", tileY / 1000 % 1000));
        path.append('/').append(String.format("%03d", tileY % 1000));
        path.append('.').append(this.tileCacheLayerInfo.getExtension());
        return new URI(commonUri.getScheme(), commonUri.getUserInfo(), commonUri.getHost(), commonUri.getPort(), commonUri.getPath() + path, commonUri.getQuery(), commonUri.getFragment());
    }

    @Override
    public boolean testMerge(MapReader other) {
        return false;
    }

    @Override
    public boolean canMerge(MapReader other) {
        return false;
    }

    @Override
    public String toString() {
        return this.layer;
    }

    public static class Factory
    implements MapReaderFactory {
        public List<MapReader> create(String type, RenderingContext context, PJsonObject params) {
            ArrayList<MapReader> target = new ArrayList<MapReader>();
            String layer = params.getString("layer");
            target.add(new TileCacheMapReader(layer, context, params));
            return target;
        }
    }
}

