/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mapfish.print.InvalidJsonValueException;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.map.readers.MapReader;
import org.mapfish.print.map.readers.MapReaderFactory;
import org.mapfish.print.utils.PJsonObject;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MapReaderFactoryFinder
implements ApplicationContextAware {
    private Map<String, MapReaderFactory> factories = new HashMap<String, MapReaderFactory>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map tmpFac = applicationContext.getBeansOfType(MapReaderFactory.class);
        for (Map.Entry entry : tmpFac.entrySet()) {
            if (!((String)entry.getKey()).contains("-")) {
                throw new BeanInitializationException("All MapFactoryReaders must have an id with format:  type-MapReaderFactory");
            }
            this.factories.put(((String)entry.getKey()).split("-")[0].toLowerCase(), (MapReaderFactory)entry.getValue());
        }
    }

    public void create(List<MapReader> readers, String type, RenderingContext context, PJsonObject params) {
        MapReaderFactory factory = this.getFactory(type);
        if (factory == null) {
            throw new InvalidJsonValueException(params, "type", type);
        }
        readers.addAll(factory.create(type, context, params));
    }

    MapReaderFactory getFactory(String type) {
        return this.factories.get(type.toLowerCase());
    }
}

