/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.map.MapTileTask;
import org.pvalsecc.concurrent.BlockingSimpleTarget;
import org.pvalsecc.concurrent.OrderedResultsExecutor;

public class ParallelMapTileLoader
implements OrderedResultsExecutor.ResultCollector<MapTileTask> {
    private final PdfContentByte dc;
    private RenderingContext context;
    private final OrderedResultsExecutor<MapTileTask> executor;
    private final BlockingSimpleTarget target = new BlockingSimpleTarget("mapTiles");
    private int nbTiles = 0;

    public ParallelMapTileLoader(RenderingContext context, PdfContentByte dc) {
        this.executor = context.getConfig().getMapRenderingExecutor();
        this.dc = dc;
        this.context = context;
    }

    public void addTileToLoad(MapTileTask task) {
        ++this.nbTiles;
        if (this.executor != null) {
            this.executor.addTask(task, this);
        } else {
            task.process();
            this.handle(task);
        }
    }

    public void waitForCompletion() {
        this.target.setTarget(this.nbTiles);
        this.target.waitForCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(MapTileTask mapTileTaskResult) {
        if (!mapTileTaskResult.handleException(this.context)) {
            Object object = this.context.getPdfLock();
            synchronized (object) {
                this.dc.saveState();
                try {
                    mapTileTaskResult.renderOnPdf(this.dc);
                }
                catch (DocumentException e) {
                    this.context.addError((Exception)((Object)e));
                }
                finally {
                    this.dc.restoreState();
                    this.target.addDone(1);
                }
            }
        }
        this.target.addDone(1);
    }
}

