/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfLayer;
import com.lowagie.text.pdf.PdfOCG;
import java.awt.Color;
import java.util.ArrayList;
import org.mapfish.print.ChunkDrawer;
import org.mapfish.print.InvalidJsonValueException;
import org.mapfish.print.JsonMissingException;
import org.mapfish.print.PDFCustomBlocks;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.MapTileTask;
import org.mapfish.print.map.ParallelMapTileLoader;
import org.mapfish.print.map.readers.MapReader;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class MapChunkDrawer
extends ChunkDrawer {
    private final Transformer transformer;
    private final double overviewMap;
    private final PJsonObject params;
    private final RenderingContext context;
    private final Color backgroundColor;
    private final String name;

    public MapChunkDrawer(PDFCustomBlocks customBlocks, Transformer transformer, double overviewMap, PJsonObject params, RenderingContext context, Color backgroundColor, String name) {
        super(customBlocks);
        this.transformer = transformer;
        this.overviewMap = overviewMap;
        this.params = params;
        this.context = context;
        this.backgroundColor = backgroundColor;
        this.name = MapChunkDrawer.computeName(overviewMap, name);
    }

    private static String computeName(double overviewMap, String name) {
        if (name != null) {
            return name;
        }
        return Double.isNaN(overviewMap) ? "map" : "overview";
    }

    @Override
    public void renderImpl(Rectangle rectangle, PdfContentByte dc) {
        PJsonObject parent = this.context.getGlobalParams();
        PJsonObject maps = null;
        try {
            if (parent.has("maps")) {
                maps = parent.getJSONObject("maps");
            }
        }
        catch (JsonMissingException jme) {
            maps = null;
        }
        if (maps != null && maps.has(this.name)) {
            PJsonObject map = maps.getJSONObject(this.name);
            this.renderMap(rectangle, dc, map);
        } else {
            this.renderMap(rectangle, dc, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderMap(Rectangle rectangle, PdfContentByte dc, PJsonObject map) {
        int i;
        PJsonArray layers = map.getJSONArray("layers");
        String srs = map.getString("srs");
        if (!this.context.getConfig().isDisableScaleLocking() && !this.context.getConfig().isScalePresent(this.transformer.getScale())) {
            throw new InvalidJsonValueException(this.params, "scale", this.transformer.getScale());
        }
        Transformer mainTransformer = null;
        if (!Double.isNaN(this.overviewMap)) {
            mainTransformer = this.context.getLayout().getMainPage().getMap().createTransformer(this.context, this.params);
            this.transformer.zoom(mainTransformer, (float)(1.0 / this.overviewMap));
            this.transformer.setRotation(0.0);
            this.context.setStyleFactor((float)((double)(this.transformer.getPaperW() / mainTransformer.getPaperW()) / this.overviewMap));
            layers = map.optJSONArray("overviewLayers", layers);
        }
        this.transformer.setMapPos(rectangle.getLeft(), rectangle.getBottom());
        if ((double)rectangle.getWidth() < (double)this.transformer.getPaperW() - 0.2) {
            throw new RuntimeException("The map width on the paper is wrong");
        }
        if ((double)rectangle.getHeight() < (double)this.transformer.getPaperH() - 0.2) {
            throw new RuntimeException("The map height on the paper is wrong (" + rectangle.getHeight() + "!=" + this.transformer.getPaperH() + ")");
        }
        ArrayList<MapReader> readers = new ArrayList<MapReader>(layers.size());
        for (i = 0; i < layers.size(); ++i) {
            PJsonObject layer = layers.getJSONObject(i);
            if (mainTransformer != null && !layer.optBool("overview", true)) continue;
            String type = layer.getString("type");
            float minScale = layer.optFloat("minScaleDenominator", -1.0f).floatValue();
            float maxScale = layer.optFloat("maxScaleDenominator", -1.0f).floatValue();
            boolean bPrint = true;
            if (minScale > -1.0f) {
                boolean bl = bPrint = !(minScale - (float)this.transformer.getScale() > 0.0f);
            }
            if (maxScale > -1.0f) {
                boolean bl = bPrint = !(maxScale - (float)this.transformer.getScale() < 0.0f);
            }
            if (!bPrint) continue;
            this.context.getConfig().getMapReaderFactoryFinder().create(readers, type, this.context, layer);
        }
        i = 1;
        while (i < readers.size()) {
            MapReader reader2;
            MapReader reader1 = (MapReader)readers.get(i - 1);
            if (reader1.testMerge(reader2 = (MapReader)readers.get(i))) {
                readers.remove(i);
                continue;
            }
            ++i;
        }
        if (this.backgroundColor != null) {
            dc.saveState();
            try {
                dc.setColorFill(this.backgroundColor);
                dc.rectangle(rectangle.getLeft(), rectangle.getBottom(), rectangle.getWidth(), rectangle.getHeight());
                dc.fill();
            }
            finally {
                dc.restoreState();
            }
        }
        ParallelMapTileLoader parallelMapTileLoader = new ParallelMapTileLoader(this.context, dc);
        dc.saveState();
        try {
            final PdfLayer mapLayer = new PdfLayer(this.name, this.context.getWriter());
            this.transformer.setClipping(dc);
            for (int i2 = 0; i2 < readers.size(); ++i2) {
                final MapReader reader = (MapReader)readers.get(i2);
                parallelMapTileLoader.addTileToLoad(new MapTileTask.RenderOnly(){

                    @Override
                    public void renderOnPdf(PdfContentByte dc) throws DocumentException {
                        PdfLayer pdfLayer = new PdfLayer(reader.toString(), MapChunkDrawer.this.context.getWriter());
                        mapLayer.addChild(pdfLayer);
                        dc.beginLayer((PdfOCG)pdfLayer);
                    }
                });
                reader.render(this.transformer, parallelMapTileLoader, srs, i2 == 0);
                parallelMapTileLoader.addTileToLoad(new MapTileTask.RenderOnly(){

                    @Override
                    public void renderOnPdf(PdfContentByte dc) throws DocumentException {
                        dc.endLayer();
                    }
                });
            }
        }
        finally {
            parallelMapTileLoader.waitForCompletion();
            dc.restoreState();
        }
        if (mainTransformer != null) {
            this.drawMapExtent(dc, mainTransformer);
            this.context.setStyleFactor(1.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawMapExtent(PdfContentByte dc, Transformer mainTransformer) {
        dc.saveState();
        try {
            this.transformer.setRotation(mainTransformer.getRotation());
            dc.transform(this.transformer.getGeoTransform(true));
            this.transformer.setRotation(0.0);
            dc.setLineWidth(1.0f * this.transformer.getGeoW() / this.transformer.getPaperW());
            dc.setColorStroke(new Color(255, 0, 0));
            dc.rectangle(mainTransformer.getMinGeoX(), mainTransformer.getMinGeoY(), mainTransformer.getGeoW(), mainTransformer.getGeoH());
            dc.stroke();
            if (mainTransformer.getRotation() != 0.0) {
                dc.setLineWidth(0.5f * this.transformer.getGeoW() / this.transformer.getPaperW());
                dc.moveTo((3.0f * mainTransformer.getMinGeoX() + mainTransformer.getMaxGeoX()) / 4.0f, mainTransformer.getMinGeoY());
                dc.lineTo((mainTransformer.getMinGeoX() + mainTransformer.getMaxGeoX()) / 2.0f, (mainTransformer.getMinGeoY() * 2.0f + mainTransformer.getMaxGeoY()) / 3.0f);
                dc.lineTo((mainTransformer.getMinGeoX() + 3.0f * mainTransformer.getMaxGeoX()) / 4.0f, mainTransformer.getMinGeoY());
                dc.stroke();
            }
        }
        finally {
            dc.restoreState();
        }
    }
}

