/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.lowagie.text.DocumentException;
import java.util.List;
import org.json.JSONException;
import org.json.JSONWriter;
import org.mapfish.print.InvalidJsonValueException;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.Block;
import org.mapfish.print.config.layout.ExtraPage;
import org.mapfish.print.config.layout.MapBlock;
import org.mapfish.print.config.layout.Page;
import org.mapfish.print.utils.PJsonObject;

public class MainPage
extends Page {
    private boolean rotation = false;

    public void setRotation(boolean rotation) {
        this.rotation = rotation;
    }

    public void printClientConfig(JSONWriter json) throws JSONException {
        MapBlock map = this.getMap();
        if (map != null) {
            json.key("map");
            map.printClientConfig(json);
        }
        json.key("rotation").value(this.rotation);
    }

    @Override
    protected Page.Position getCurrentPosition() {
        return Page.Position.MAIN_PAGE;
    }

    public void render(PJsonObject params, RenderingContext context, List<ExtraPage> extraPages) throws DocumentException {
        float rotation = params.optFloat("rotation", 0.0f).floatValue();
        if (rotation != 0.0f && !this.rotation) {
            throw new InvalidJsonValueException(params, "rotation", Float.valueOf(rotation));
        }
        super.render(params, context);
    }

    public MapBlock getMap() {
        MapBlock result = null;
        for (int i = 0; i < this.items.size() && result == null; ++i) {
            Block block = (Block)this.items.get(i);
            result = block.getMap();
        }
        return result;
    }
}

