/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.lowagie.text.DocumentException;
import java.util.ArrayList;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.Block;
import org.mapfish.print.config.layout.Page;
import org.mapfish.print.utils.PJsonObject;

public class ExtraPage
extends Page {
    public static final String AFTER_LAST_PAGE = "afterLastPage";
    public static final String BEFORE_LAST_PAGE = "beforeLastPage";
    public static final String BEFORE_MAIN_PAGE = "beforeMainPage";
    private String renderOn = "afterLastPage";

    public void setRenderBlock(Block renderBlock) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        this.items.add(renderBlock);
    }

    public String getRenderOn() {
        return this.renderOn;
    }

    public void setRenderOn(String renderOn) {
        this.renderOn = renderOn;
    }

    public static ExtraPage createAfter(Page.Position position, Block renderBlock, Page basePage) {
        ExtraPage page = new ExtraPage();
        if (basePage != null) {
            basePage.applyPageFormat(page);
        }
        switch (position) {
            case MAIN_PAGE: {
                page.setRenderOn(BEFORE_LAST_PAGE);
                break;
            }
            case TITLE_PAGE: {
                page.setRenderOn(BEFORE_MAIN_PAGE);
                break;
            }
            default: {
                page.setRenderOn(AFTER_LAST_PAGE);
            }
        }
        page.setRenderBlock(renderBlock);
        return page;
    }

    @Override
    public void render(PJsonObject params, RenderingContext context) throws DocumentException {
        ArrayList itemsToRender = new ArrayList();
        itemsToRender.addAll(this.items);
        while (itemsToRender.size() > 0) {
            Block item = (Block)itemsToRender.remove(0);
            this.items.clear();
            this.items.add(item);
            while (item.hasExtraRendering()) {
                super.render(params, context);
            }
        }
    }
}

