/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.ho.yaml.CustomYamlConfig;
import org.mapfish.print.config.Config;
import org.mapfish.print.map.readers.MapReaderFactoryFinder;
import org.mapfish.print.output.OutputFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class ConfigFactory {
    private OutputFactory outputFactoryFinder;
    private MapReaderFactoryFinder mapReaderFactoryFinder;

    @Autowired
    @Required
    public void setOutputFactoryFinder(OutputFactory outputFactoryFinder) {
        this.outputFactoryFinder = outputFactoryFinder;
    }

    @Autowired
    @Required
    public void setMapReaderFactoryFinder(MapReaderFactoryFinder mapReaderFactoryFinder) {
        this.mapReaderFactoryFinder = mapReaderFactoryFinder;
    }

    public Config fromYaml(File file) throws FileNotFoundException {
        CustomYamlConfig config = new CustomYamlConfig();
        Config result = (Config)config.loadType(file, Config.class);
        result.setOutputFactory(this.outputFactoryFinder);
        result.setMapReaderFactoryFinder(this.mapReaderFactoryFinder);
        result.validate();
        return result;
    }

    public Config fromInputStream(InputStream instream) {
        CustomYamlConfig config = new CustomYamlConfig();
        Config result = (Config)config.loadType(instream, Config.class);
        result.setOutputFactory(this.outputFactoryFinder);
        result.setMapReaderFactoryFinder(this.mapReaderFactoryFinder);
        result.validate();
        return result;
    }

    public Config fromString(String strConfig) {
        CustomYamlConfig config = new CustomYamlConfig();
        Config result = (Config)config.loadType(strConfig, Config.class);
        result.setOutputFactory(this.outputFactoryFinder);
        result.setMapReaderFactoryFinder(this.mapReaderFactoryFinder);
        result.validate();
        return result;
    }
}

