/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mapfish.print.PDFCustomBlocks;
import org.mapfish.print.config.Config;
import org.mapfish.print.config.layout.ExtraPage;
import org.mapfish.print.config.layout.Layout;
import org.mapfish.print.config.layout.Page;
import org.mapfish.print.utils.PJsonObject;

public class RenderingContext {
    private final Document document;
    private final PdfWriter writer;
    private final Config config;
    private final PJsonObject globalParams;
    private final String configDir;
    private final PDFCustomBlocks customBlocks;
    private final Layout layout;
    private final Map<String, String> headers;
    private final List<ExtraPage> extraPages = new ArrayList<ExtraPage>();
    private Page.Position currentPosition = Page.Position.NONE;
    private Page currentPage = null;
    private PJsonObject currentPageParams = null;
    private float styleFactor = 1.0f;
    private Map<URI, PdfTemplate> templateCache = Collections.synchronizedMap(new HashMap());
    private final Object pdfLock = new Object();

    public RenderingContext(Document document, PdfWriter writer, Config config, PJsonObject globalParams, String configDir, Layout layout, Map<String, String> headers) {
        this.document = document;
        this.writer = writer;
        this.config = config;
        this.globalParams = globalParams;
        this.configDir = configDir;
        this.layout = layout;
        this.headers = headers;
        this.customBlocks = new PDFCustomBlocks(writer, this);
    }

    public PDFCustomBlocks getCustomBlocks() {
        return this.customBlocks;
    }

    public Document getDocument() {
        return this.document;
    }

    public Config getConfig() {
        return this.config;
    }

    public PdfWriter getWriter() {
        return this.writer;
    }

    public PdfContentByte getDirectContent() {
        return this.writer.getDirectContent();
    }

    public PJsonObject getGlobalParams() {
        return this.globalParams;
    }

    public void setCurrentPageParams(PJsonObject pageParams) {
        this.currentPageParams = pageParams;
    }

    public PJsonObject getCurrentPageParams() {
        return this.currentPageParams;
    }

    public String getConfigDir() {
        return this.configDir;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void addError(Exception e) {
        this.customBlocks.addError(e);
    }

    public float getStyleFactor() {
        return this.styleFactor;
    }

    public void setStyleFactor(float styleFactor) {
        this.styleFactor = styleFactor;
    }

    public Map<URI, PdfTemplate> getTemplateCache() {
        return this.templateCache;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Object getPdfLock() {
        return this.pdfLock;
    }

    public void setCurrentPosition(Page.Position currentPosition) {
        this.currentPosition = currentPosition;
    }

    public Page.Position getCurrentPosition() {
        return this.currentPosition;
    }

    public List<ExtraPage> getExtraPages() {
        return this.extraPages;
    }

    public void setCurrentPage(Page currentPage) {
        this.currentPage = currentPage;
    }

    public Page getCurrentPage() {
        return this.currentPage;
    }
}

