/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wmts;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.service.OWSException;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.util.ServletUtils;

public class WMTSGetFeatureInfo {
    private static Logger log = Logging.getLogger((String)"org.geowebcache.service.wmts.WMTSService");
    private ConveyorTile convTile;
    int i;
    int j;

    protected WMTSGetFeatureInfo(ConveyorTile convTile) throws OWSException {
        String[] keys = new String[]{"i", "j"};
        Map values = ServletUtils.selectedStringsFromMap((Map)convTile.getRequestParameters(), (String)convTile.servletReq.getCharacterEncoding(), (String[])keys);
        try {
            this.i = Integer.parseInt((String)values.get("i"));
        }
        catch (NumberFormatException nfe) {
            throw new OWSException(400, "MissingParameterValue", "I", "I was not specified");
        }
        try {
            this.j = Integer.parseInt((String)values.get("j"));
        }
        catch (NumberFormatException nfe) {
            throw new OWSException(400, "MissingParameterValue", "J", "J was not specified");
        }
        this.convTile = convTile;
    }

    protected void writeResponse(RuntimeStats stats) throws OWSException {
        TileLayer layer = this.convTile.getLayer();
        GridSet gridSet = this.convTile.getGridSubset().getGridSet();
        if (gridSet.getTileHeight() < this.j || this.j < 0) {
            throw new OWSException(400, "PointIJOutOfRange", "J", "J was " + this.j + ", must be between 0 and " + gridSet.getTileHeight());
        }
        if (gridSet.getTileWidth() < this.i || this.i < 0) {
            throw new OWSException(400, "PointIJOutOfRange", "I", "I was " + this.i + ", must be between 0 and " + gridSet.getTileWidth());
        }
        Resource data = null;
        try {
            BoundingBox bbox = this.convTile.getGridSubset().boundsFromIndex(this.convTile.getTileIndex());
            data = layer.getFeatureInfo(this.convTile, bbox, this.convTile.getGridSubset().getTileHeight(), this.convTile.getGridSubset().getTileWidth(), this.i, this.j);
        }
        catch (GeoWebCacheException e) {
            throw new OWSException(500, "NoApplicableCode", "", e.getMessage());
        }
        this.convTile.servletResp.setStatus(200);
        this.convTile.servletResp.setContentType(this.convTile.getMimeType().getMimeType());
        int size = (int)data.getSize();
        this.convTile.servletResp.setContentLength(size);
        stats.log(size, Conveyor.CacheResult.OTHER);
        try {
            ServletOutputStream os = this.convTile.servletResp.getOutputStream();
            data.transferTo(Channels.newChannel((OutputStream)os));
            os.flush();
        }
        catch (IOException ioe) {
            log.fine("Caught IOException" + ioe.getMessage());
        }
    }
}

