/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wmts;

import org.geowebcache.service.wmts.WMTSUtils;
import org.junit.Assert;
import org.junit.Test;

public class WMTSUtilsTest {
    @Test
    public void testKvpServiceMetadataURLNoParameters() throws Exception {
        String result = WMTSUtils.getKvpServiceMetadataURL((String)"https://www.foo.com/");
        Assert.assertEquals((Object)"https://www.foo.com/?SERVICE=wmts&REQUEST=getcapabilities&VERSION=1.0.0", (Object)result);
    }

    @Test
    public void testKvpServiceMetadataURLNoParametersWithAnchor() throws Exception {
        String result = WMTSUtils.getKvpServiceMetadataURL((String)"https://www.foo.com/#anchor");
        Assert.assertEquals((Object)"https://www.foo.com/?SERVICE=wmts&REQUEST=getcapabilities&VERSION=1.0.0#anchor", (Object)result);
    }

    @Test
    public void testKvpServiceMetadataURLNoParameters_questionMark() throws Exception {
        String result = WMTSUtils.getKvpServiceMetadataURL((String)"https://www.foo.com/?");
        Assert.assertEquals((Object)"https://www.foo.com/?SERVICE=wmts&REQUEST=getcapabilities&VERSION=1.0.0", (Object)result);
    }

    @Test
    public void testKvpServiceMetadataURLSingleParameter() throws Exception {
        String result = WMTSUtils.getKvpServiceMetadataURL((String)"https://www.foo.com/?bar=doo");
        Assert.assertEquals((Object)"https://www.foo.com/?bar=doo&SERVICE=wmts&REQUEST=getcapabilities&VERSION=1.0.0", (Object)result);
    }

    @Test
    public void testKvpServiceMetadataURLSingleParameter_ampersand() throws Exception {
        String result = WMTSUtils.getKvpServiceMetadataURL((String)"https://www.foo.com/?bar=doo&");
        Assert.assertEquals((Object)"https://www.foo.com/?bar=doo&SERVICE=wmts&REQUEST=getcapabilities&VERSION=1.0.0", (Object)result);
    }

    @Test
    public void testKvpServiceMetadataURLMultipleParameters() throws Exception {
        String result = WMTSUtils.getKvpServiceMetadataURL((String)"https://www.foo.com/?bar=doo&dii=daa");
        Assert.assertEquals((Object)"https://www.foo.com/?bar=doo&dii=daa&SERVICE=wmts&REQUEST=getcapabilities&VERSION=1.0.0", (Object)result);
    }

    @Test
    public void testKvpServiceMetadataURLMultipleParameters_manyAmpersands() throws Exception {
        String result = WMTSUtils.getKvpServiceMetadataURL((String)"https://www.foo.com/?bar=doo&dii=daa&&&");
        Assert.assertEquals((Object)"https://www.foo.com/?bar=doo&dii=daa&SERVICE=wmts&REQUEST=getcapabilities&VERSION=1.0.0", (Object)result);
    }

    @Test
    public void testKvpServiceMetadataURLMultipleParameters_manyAmpersands_withAnchor() throws Exception {
        String result = WMTSUtils.getKvpServiceMetadataURL((String)"https://www.foo.com/?bar=doo&dii=daa&&&#hello");
        Assert.assertEquals((Object)"https://www.foo.com/?bar=doo&dii=daa&SERVICE=wmts&REQUEST=getcapabilities&VERSION=1.0.0#hello", (Object)result);
    }
}

