/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wmts;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.ServerConfiguration;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.config.legends.LegendInfo;
import org.geowebcache.config.legends.LegendInfoBuilder;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.filter.security.SecurityDispatcher;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileJSONProvider;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.meta.TileJSON;
import org.geowebcache.layer.meta.VectorLayerMetadata;
import org.geowebcache.mime.ApplicationMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.service.OWSException;
import org.geowebcache.service.wmts.WMTSService;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.ResponseUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.springframework.context.annotation.Bean;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class WMTSRestTest {
    GridSetBroker broker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true)));
    private WMTSService wmtsService;
    private StorageBroker storageBroker;
    private TileLayerDispatcher tileLayerDispatcher;
    private SecurityDispatcher securityDispatcher;
    private RuntimeStats runtimeStats;

    @Before
    public void setupMockService() throws Exception {
        this.storageBroker = (StorageBroker)Mockito.mock(StorageBroker.class);
        this.tileLayerDispatcher = this.tileLayerDispatcher();
        this.runtimeStats = (RuntimeStats)Mockito.mock(RuntimeStats.class);
        this.wmtsService = new WMTSService(this.storageBroker, this.tileLayerDispatcher, this.broker, this.runtimeStats);
        this.securityDispatcher = this.securityDispatcher();
        this.wmtsService.setSecurityDispatcher(this.securityDispatcher);
    }

    @BeforeClass
    public static void setupXMLUnit() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("ows", "http://www.opengis.net/ows/1.1");
        namespaces.put("wmts", "http://www.opengis.net/wmts/1.0");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    @Test
    public void testGetCap() throws Exception {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setPathInfo("geowebcache/service/wmts/rest/WMTSCapabilities.xml");
        MockHttpServletResponse resp = this.dispatch(req);
        Assert.assertEquals((long)200L, (long)resp.getStatus());
        Assert.assertEquals((Object)"text/xml;charset=UTF-8", (Object)resp.getContentType());
        Document doc = XMLUnit.buildTestDocument((String)resp.getContentAsString());
        XMLAssert.assertXpathExists((String)"//wmts:Contents/wmts:Layer", (Document)doc);
        XMLAssert.assertXpathExists((String)"//wmts:Contents/wmts:Layer[ows:Identifier='mockLayer']", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wmts:Contents/wmts:Layer/wmts:Style/ows:Identifier)", (Document)doc);
        XMLAssert.assertXpathExists((String)"//wmts:Contents/wmts:Layer/wmts:Style[ows:Identifier='style-a']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//wmts:Contents/wmts:Layer/wmts:Style[ows:Identifier='style-b']/wmts:LegendURL[@width='125'][@height='130'][@format='image/png'][@minScaleDenominator='5000.0'][@maxScaleDenominator='10000.0'][@xlink:href='https://some-url?some-parameter=value3&another-parameter=value4']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//wmts:Contents/wmts:Layer/wmts:ResourceURL[@resourceType='tile'][@format='image/jpeg'][@template='http://localhost/service/wmts/rest/mockLayer/{style}/{TileMatrixSet}/{TileMatrix}/{TileRow}/{TileCol}?format=image/jpeg&time={time}&elevation={elevation}']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//wmts:Contents/wmts:Layer/wmts:ResourceURL[@resourceType='FeatureInfo'][@format='text/plain'][@template='http://localhost/service/wmts/rest/mockLayer/{style}/{TileMatrixSet}/{TileMatrix}/{TileRow}/{TileCol}/{J}/{I}?format=text/plain&time={time}&elevation={elevation}']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//wmts:ServiceMetadataURL[@xlink:href='http://localhost/service/wmts/rest/WMTSCapabilities.xml']", (Document)doc);
    }

    @Test
    public void testGetTileWithStyle() throws Exception {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setPathInfo("geowebcache/service/wmts/rest/mockLayer/style-a/EPSG:4326/EPSG:4326:0/0/0");
        req.addParameter("format", "image/png");
        MockHttpServletResponse resp = this.dispatch(req);
        Assert.assertEquals((long)200L, (long)resp.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)resp.getContentType());
        Assert.assertEquals((Object)"EPSG:4326", (Object)resp.getHeader("geowebcache-crs"));
        Assert.assertArrayEquals((byte[])this.getSampleTileContent().getContents(), (byte[])resp.getContentAsByteArray());
    }

    @Test
    public void testGetTileJSONWithStyle() throws Exception {
        this.addTileLayerJsonMock("image/png");
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setPathInfo("geowebcache/service/wmts/rest/mockLayerTileJSON/style-a/tilejson/png");
        req.addParameter("format", "application/json");
        MockHttpServletResponse resp = this.dispatch(req);
        Assert.assertEquals((long)200L, (long)resp.getStatus());
        String content = resp.getContentAsString();
        Assert.assertTrue((boolean)content.contains("\"tiles\":[\"http://localhost/service/wmts/rest/mockLayerTileJSON/style-a/EPSG:900913/EPSG:900913:{z}/{y}/{x}?format=image/png\"]"));
        Assert.assertFalse((boolean)content.contains("vector_layers"));
    }

    @Test
    public void testGetTileJSONWithoutStyle() throws Exception {
        String mvt = ApplicationMime.mapboxVector.getFormat();
        this.addTileLayerJsonMock(mvt);
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setPathInfo("geowebcache/service/wmts/rest/mockLayerTileJSON/tilejson/pbf");
        req.addParameter("format", ApplicationMime.json.getFormat());
        MockHttpServletResponse resp = this.dispatch(req);
        Assert.assertEquals((long)200L, (long)resp.getStatus());
        String content = resp.getContentAsString();
        Assert.assertTrue((boolean)content.contains("\"tiles\":[\"http://localhost/service/wmts/rest/mockLayerTileJSON/EPSG:900913/EPSG:900913:{z}/{y}/{x}?format=" + mvt + "\"]"));
        Assert.assertTrue((boolean)content.contains("vector_layers"));
    }

    private void addTileLayerJsonMock(String mimeType) throws GeoWebCacheException {
        MimeType mimeType1 = MimeType.createFromFormat((String)mimeType);
        String layerNameJson = "mockLayerTileJSON";
        TileLayer tileLayerJson = (TileLayer)Mockito.mock(TileLayer.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{TileJSONProvider.class}));
        Mockito.when((Object)this.tileLayerDispatcher.getTileLayer((String)ArgumentMatchers.eq((Object)layerNameJson))).thenReturn((Object)tileLayerJson);
        Mockito.when((Object)tileLayerJson.getName()).thenReturn((Object)layerNameJson);
        Mockito.when((Object)tileLayerJson.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)tileLayerJson.isAdvertised()).thenReturn((Object)true);
        Mockito.when((Object)tileLayerJson.getMimeTypes()).thenReturn(Arrays.asList(mimeType1));
        TileJSONProvider tileJSONProvider = (TileJSONProvider)tileLayerJson;
        Mockito.when((Object)tileJSONProvider.supportsTileJSON()).thenReturn((Object)true);
        TileJSON json = new TileJSON();
        VectorLayerMetadata metadata = new VectorLayerMetadata();
        metadata.setFields(Collections.singletonMap("FIELD", "TYPE"));
        json.setLayers(Collections.singletonList(metadata));
        Mockito.when((Object)tileJSONProvider.getTileJSON()).thenReturn((Object)json);
        String googleMercator = "EPSG:900913";
        Mockito.when((Object)tileLayerJson.getGridSubsets()).thenReturn(Collections.singleton(googleMercator));
        GridSubset subset = (GridSubset)Mockito.mock(GridSubset.class);
        Mockito.when((Object)subset.getGridNames()).thenReturn((Object)new String[]{googleMercator + ":1"});
        Mockito.when((Object)tileLayerJson.getGridSubset((String)ArgumentMatchers.eq((Object)googleMercator))).thenReturn((Object)subset);
        Mockito.when((Object)this.tileLayerDispatcher.getLayerList()).thenReturn(Arrays.asList(tileLayerJson));
        Mockito.when((Object)this.tileLayerDispatcher.getLayerListFiltered()).thenReturn(Arrays.asList(tileLayerJson));
    }

    public MockHttpServletResponse dispatch(MockHttpServletRequest req) throws Exception {
        MockHttpServletResponse resp = new MockHttpServletResponse();
        try {
            Conveyor conveyor = this.wmtsService.getConveyor((HttpServletRequest)req, (HttpServletResponse)resp);
            if (conveyor.reqHandler == Conveyor.RequestHandler.SERVICE) {
                String layerName = conveyor.getLayerId();
                if (Objects.nonNull(layerName)) {
                    TileLayer layer = this.tileLayerDispatcher.getTileLayer(layerName);
                    if (layer != null && !layer.isEnabled()) {
                        throw new OWSException(400, "InvalidParameterValue", "LAYERS", "Layer '" + layerName + "' is disabled");
                    }
                    if (conveyor instanceof ConveyorTile) {
                        ((ConveyorTile)conveyor).setTileLayer(layer);
                    }
                }
                this.wmtsService.handleRequest(conveyor);
            } else {
                ResponseUtils.writeTile((SecurityDispatcher)this.securityDispatcher(), (Conveyor)conveyor, (String)conveyor.getLayerId(), (TileLayerDispatcher)this.tileLayerDispatcher(), null, (RuntimeStats)this.runtimeStats);
            }
        }
        catch (OWSException e) {
            ResponseUtils.writeFixedResponse((HttpServletResponse)resp, (int)e.getResponseCode(), (String)e.getContentType(), (Resource)e.getResponse(), (Conveyor.CacheResult)Conveyor.CacheResult.OTHER, (RuntimeStats)this.runtimeStats);
        }
        return resp;
    }

    @Test
    public void testGetTileWithoutStyle() throws Exception {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setPathInfo("geowebcache/service/wmts/rest/mockLayer/EPSG:4326/EPSG:4326:0/0/0");
        req.addParameter("format", "image/png");
        MockHttpServletResponse resp = this.dispatch(req);
        Assert.assertEquals((long)200L, (long)resp.getStatus());
    }

    @Test
    public void testGetTileWithEmptyStyle() throws Exception {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setPathInfo("geowebcache/service/wmts/rest/mockLayer//EPSG:4326/EPSG:4326:0/0/0");
        req.addParameter("format", "image/png");
        MockHttpServletResponse resp = this.dispatch(req);
        Assert.assertEquals((long)200L, (long)resp.getStatus());
    }

    @Test
    public void testGetInfoWithStyle() throws Exception {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setPathInfo("geowebcache/service/wmts/rest/mockLayer/style-a/EPSG:4326/EPSG:4326:0/0/0/0/0");
        req.addParameter("format", "text/plain");
        MockHttpServletResponse resp = this.dispatch(req);
        Assert.assertEquals((long)200L, (long)resp.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)resp.getContentType());
    }

    @Test
    public void testGetInfoWithoutStyle() throws Exception {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setPathInfo("geowebcache/service/wmts/rest/mockLayer/EPSG:4326/EPSG:4326:0/0/0/0/0");
        req.addParameter("format", "text/plain");
        MockHttpServletResponse resp = this.dispatch(req);
        Assert.assertEquals((long)200L, (long)resp.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)resp.getContentType());
    }

    @Test
    public void testOWSException() throws Exception {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setPathInfo("geowebcache/service/wmts/rest/mockLayer/EPSG:4326/EPSG:4326:0/0/0/0/0");
        req.addParameter("format", "text/none");
        MockHttpServletResponse resp = this.dispatch(req);
        Assert.assertEquals((long)400L, (long)resp.getStatus());
        Assert.assertEquals((Object)"text/xml", (Object)resp.getContentType());
        Document doc = XMLUnit.buildTestDocument((String)resp.getContentAsString());
        XMLAssert.assertXpathExists((String)"//ows:ExceptionReport/ows:Exception[@exceptionCode='InvalidParameterValue']", (Document)doc);
    }

    @Test
    public void testGetCapabilitiesWithCiteValidation() throws Exception {
        this.testCiteValidationIsSuccessful(this::testGetCap);
    }

    @Test
    public void testGetTileWithCiteValidation() throws Exception {
        this.testCiteValidationIsSuccessful(() -> {
            this.testGetTileWithStyle();
            this.testGetTileWithoutStyle();
        });
    }

    @Test
    public void testGetInfoWithCiteValidation() throws Exception {
        this.testCiteValidationIsSuccessful(() -> {
            this.testGetInfoWithStyle();
            this.testGetInfoWithoutStyle();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCiteValidationIsSuccessful(TestToExecute request) throws Exception {
        ServerConfiguration configuration = (ServerConfiguration)Mockito.mock(ServerConfiguration.class);
        Mockito.when((Object)configuration.isWmtsCiteCompliant()).thenReturn((Object)true);
        ServerConfiguration previousConfiguration = this.wmtsService.getMainConfiguration();
        this.wmtsService.setMainConfiguration(configuration);
        try {
            request.execute();
        }
        finally {
            this.wmtsService.setMainConfiguration(previousConfiguration);
        }
    }

    public TileLayerDispatcher tileLayerDispatcher() throws Exception {
        TileLayerDispatcher tld = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        List<String> gridSetNames = Arrays.asList("GlobalCRS84Pixel", "GlobalCRS84Scale", "EPSG:4326");
        String layerName = "mockLayer";
        TileLayer tileLayer = (TileLayer)Mockito.mock(TileLayer.class);
        StringParameterFilter styles = new StringParameterFilter();
        styles.setKey("STYLES");
        styles.setValues(Arrays.asList("style-a", "style-b"));
        StringParameterFilter time = new StringParameterFilter();
        time.setKey("time");
        time.setValues(Arrays.asList("2016-02-23T03:00:00.000Z"));
        StringParameterFilter elevation = new StringParameterFilter();
        elevation.setKey("elevation");
        elevation.setValues(Arrays.asList("500"));
        Mockito.when((Object)tileLayer.getParameterFilters()).thenReturn(Arrays.asList(styles, time, elevation));
        LegendInfo legendInfo2 = new LegendInfoBuilder().withStyleName("styla-b-legend").withWidth(Integer.valueOf(125)).withHeight(Integer.valueOf(130)).withFormat("image/png").withCompleteUrl("https://some-url?some-parameter=value3&another-parameter=value4").withMinScale(Double.valueOf(5000.0)).withMaxScale(Double.valueOf(10000.0)).build();
        Mockito.when((Object)tileLayer.getLayerLegendsInfo()).thenReturn(Collections.singletonMap("style-b", legendInfo2));
        Mockito.when((Object)tld.getTileLayer((String)ArgumentMatchers.eq((Object)layerName))).thenReturn((Object)tileLayer);
        Mockito.when((Object)tileLayer.getName()).thenReturn((Object)layerName);
        Mockito.when((Object)tileLayer.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)tileLayer.isAdvertised()).thenReturn((Object)true);
        MimeType mimeType1 = MimeType.createFromFormat((String)"image/png");
        MimeType mimeType2 = MimeType.createFromFormat((String)"image/jpeg");
        Mockito.when((Object)tileLayer.getMimeTypes()).thenReturn(Arrays.asList(mimeType1, mimeType2));
        MimeType infoMimeType1 = MimeType.createFromFormat((String)"text/plain");
        MimeType infoMimeType2 = MimeType.createFromFormat((String)"text/html");
        MimeType infoMimeType3 = MimeType.createFromFormat((String)"application/vnd.ogc.gml");
        Mockito.when((Object)tileLayer.getInfoMimeTypes()).thenReturn(Arrays.asList(infoMimeType1, infoMimeType2, infoMimeType3));
        HashMap<String, GridSubset> subsets = new HashMap<String, GridSubset>();
        HashMap<SRS, ArrayList<GridSubset>> bySrs = new HashMap<SRS, ArrayList<GridSubset>>();
        for (String gsetName : gridSetNames) {
            GridSet gridSet = this.broker.get(gsetName);
            XMLGridSubset xmlGridSubset = new XMLGridSubset();
            String gridSetName = gridSet.getName();
            xmlGridSubset.setGridSetName(gridSetName);
            GridSubset gridSubSet = xmlGridSubset.getGridSubSet(this.broker);
            subsets.put(gsetName, gridSubSet);
            ArrayList<GridSubset> list = (ArrayList<GridSubset>)bySrs.get(gridSet.getSrs());
            if (list == null) {
                list = new ArrayList<GridSubset>();
                bySrs.put(gridSet.getSrs(), list);
            }
            list.add(gridSubSet);
            Mockito.when((Object)tileLayer.getGridSubset((String)ArgumentMatchers.eq((Object)gsetName))).thenReturn((Object)gridSubSet);
        }
        for (SRS srs : bySrs.keySet()) {
            List list = (List)bySrs.get(srs);
            Mockito.when((Object)tileLayer.getGridSubsetsForSRS((SRS)ArgumentMatchers.eq((Object)srs))).thenReturn((Object)list);
        }
        Mockito.when((Object)tileLayer.getGridSubsets()).thenReturn(subsets.keySet());
        Mockito.when((Object)tld.getLayerList()).thenReturn(Arrays.asList(tileLayer));
        Mockito.when((Object)tld.getLayerListFiltered()).thenReturn(Arrays.asList(tileLayer));
        Mockito.when((Object)tileLayer.getTile((ConveyorTile)ArgumentMatchers.any(ConveyorTile.class))).thenAnswer(invocation -> {
            ConveyorTile sourceTile = (ConveyorTile)invocation.getArguments()[0];
            sourceTile.setBlob((Resource)this.getSampleTileContent());
            return sourceTile;
        });
        Mockito.when((Object)tileLayer.getFeatureInfo((ConveyorTile)ArgumentMatchers.any(ConveyorTile.class), (BoundingBox)ArgumentMatchers.any(BoundingBox.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenAnswer(invocation -> new ByteArrayResource(new byte[0]));
        return tld;
    }

    public ByteArrayResource getSampleTileContent() throws IOException, URISyntaxException {
        return new ByteArrayResource(FileUtils.readFileToByteArray((File)new File(this.getClass().getResource("/image.png").toURI())));
    }

    @Bean
    public SecurityDispatcher securityDispatcher() {
        SecurityDispatcher secDisp = (SecurityDispatcher)Mockito.mock(SecurityDispatcher.class);
        Mockito.when((Object)secDisp.isSecurityEnabled()).thenReturn((Object)false);
        return secDisp;
    }

    @FunctionalInterface
    public static interface TestToExecute {
        public void execute() throws Exception;
    }
}

