/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config.wms;

import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import org.easymock.EasyMock;
import org.geotools.data.ows.OperationType;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.WMSCapabilities;
import org.geotools.ows.wms.WMSRequest;
import org.geotools.ows.wms.WebMapServer;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.DefaultingConfiguration;
import org.geowebcache.config.LayerConfigurationTest;
import org.geowebcache.config.TileLayerConfiguration;
import org.geowebcache.config.wms.GetCapabilitiesConfiguration;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSLayer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class GetCapabilitiesLayerConfigurationConformanceTest
extends LayerConfigurationTest {
    private GridSetBroker broker;

    @Before
    public void setupBroker() {
        if (this.broker == null) {
            this.broker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false)));
        }
    }

    protected void doModifyInfo(TileLayer info, int rand) throws Exception {
        ((WMSLayer)info).setWmsLayers(Integer.toString(rand));
    }

    protected TileLayer getGoodInfo(String id, int rand) throws Exception {
        return new WMSLayer(id, new String[]{"http://foo"}, "style", Integer.toString(rand), Collections.emptyList(), Collections.singletonMap("EPSG:4326", GridSubsetFactory.createGridSubSet((GridSet)this.broker.getWorldEpsg4326())), Collections.emptyList(), new int[]{3, 3}, "", false, null);
    }

    protected TileLayer getBadInfo(String id, int rand) throws Exception {
        Assume.assumeFalse((boolean)true);
        return null;
    }

    protected String getExistingInfo() {
        return "testExisting";
    }

    protected TileLayerConfiguration getConfig() throws Exception {
        final WebMapServer server = (WebMapServer)EasyMock.createNiceMock(WebMapServer.class);
        WMSCapabilities cap = (WMSCapabilities)EasyMock.createNiceMock(WMSCapabilities.class);
        WMSRequest req = (WMSRequest)EasyMock.createNiceMock(WMSRequest.class);
        OperationType gcOpType = (OperationType)EasyMock.createNiceMock(OperationType.class);
        DefaultingConfiguration globalConfig = (DefaultingConfiguration)EasyMock.createNiceMock(DefaultingConfiguration.class);
        this.setupBroker();
        Layer l = new Layer();
        l.setName("testExisting");
        l.setLatLonBoundingBox(new CRSEnvelope());
        LinkedList<Layer> layers = new LinkedList<Layer>();
        layers.add(l);
        EasyMock.expect((Object)cap.getLayerList()).andReturn(layers);
        EasyMock.expect((Object)server.getCapabilities()).andStubReturn((Object)cap);
        EasyMock.expect((Object)cap.getRequest()).andStubReturn((Object)req);
        EasyMock.expect((Object)req.getGetCapabilities()).andStubReturn((Object)gcOpType);
        EasyMock.expect((Object)gcOpType.getGet()).andStubReturn((Object)new URL("http://test/wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=getcapabilities"));
        EasyMock.expect((Object)cap.getVersion()).andStubReturn((Object)"1.1.1");
        EasyMock.replay((Object[])new Object[]{server, cap, req, gcOpType, globalConfig});
        GetCapabilitiesConfiguration config = new GetCapabilitiesConfiguration(this.broker, "http://test/wms", "image/png", "3x3", "", null, "false"){

            WebMapServer getWMS() {
                return server;
            }
        };
        config.setGridSetBroker(this.broker);
        config.afterPropertiesSet();
        return config;
    }

    protected TileLayerConfiguration getSecondConfig() throws Exception {
        Assume.assumeTrue((String)"This configuration does not have persistance", (boolean)false);
        return null;
    }

    protected Matcher<TileLayer> infoEquals(TileLayer expected) {
        return Matchers.allOf((Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)expected.getName())), (Matcher)Matchers.hasProperty((String)"wmsLayers", (Matcher)Matchers.equalTo((Object)((WMSLayer)expected).getWmsLayers())));
    }

    protected Matcher<TileLayer> infoEquals(int expected) {
        return Matchers.hasProperty((String)"wmsLayers", (Matcher)Matchers.equalTo((Object)expected));
    }

    public void failNextRead() {
        Assume.assumeFalse((boolean)true);
    }

    public void failNextWrite() {
        Assume.assumeFalse((boolean)true);
    }

    protected void renameInfo(TileLayerConfiguration config, String name1, String name2) throws Exception {
        Assume.assumeFalse((boolean)true);
    }

    protected void addInfo(TileLayerConfiguration config, TileLayer info) throws Exception {
        Assume.assumeFalse((boolean)true);
    }

    protected void removeInfo(TileLayerConfiguration config, String name) throws Exception {
        Assume.assumeFalse((boolean)true);
    }

    protected void modifyInfo(TileLayerConfiguration config, TileLayer info) throws Exception {
        Assume.assumeFalse((boolean)true);
    }

    @Test
    public void testCanSaveGoodInfo() throws Exception {
        Assert.assertThat((Object)((TileLayerConfiguration)this.config).canSave(this.getGoodInfo("test", 1)), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    @Ignore
    public void testRemoveNotExists() throws Exception {
        super.testRemoveNotExists();
    }

    @Test
    @Ignore
    public void testModifyNotExistsExcpetion() throws Exception {
        super.testModifyNotExistsExcpetion();
    }
}

