/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.jetty;

import java.io.IOException;
import java.util.Objects;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.rules.ExternalResource;

public class HttpClientRule
extends ExternalResource {
    private CredentialsProvider creds;
    private CloseableHttpClient client;
    private String name;

    private static CredentialsProvider providerForCreds(String username, String password) {
        BasicCredentialsProvider creds = new BasicCredentialsProvider();
        creds.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        return creds;
    }

    public HttpClientRule(String username, String password, String clientName) {
        this(HttpClientRule.providerForCreds(username, password), clientName);
    }

    public HttpClientRule(CredentialsProvider creds, String clientName) {
        this.creds = creds;
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (creds != null) {
            builder.setDefaultCredentialsProvider(creds);
        }
        this.client = builder.build();
    }

    protected void before() throws Throwable {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (this.creds != null) {
            builder.setDefaultCredentialsProvider(this.creds);
        }
        this.client = builder.build();
    }

    protected void after() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                throw new AssertionError("Unexpected exception while closing HTTP Client " + this.name, e);
            }
        }
    }

    public CloseableHttpClient getClient() {
        Objects.requireNonNull(this.client);
        return this.client;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("HttpClientRule[%s]", this.name);
    }

    public static HttpClientRule anonymous(String clientName) {
        return new HttpClientRule(null, clientName);
    }

    public static HttpClientRule anonymous() {
        return HttpClientRule.anonymous("anonymous");
    }
}

