/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.tms;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geowebcache.GeoWebCacheDispatcher;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeType;
import org.geowebcache.service.tms.TMSDocumentFactory;
import org.geowebcache.service.tms.TMSService;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.URLMangler;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class TMSServiceTest {
    private TMSService service;
    private StorageBroker sb;
    private TileLayerDispatcher tld;
    private TileLayerDispatcher customTld;
    private GridSetBroker gridsetBroker;
    private URLMangler httpsUrlMangler;
    private TMSDocumentFactory customFactory;

    @Before
    public void setUp() throws Exception {
        this.sb = (StorageBroker)Mockito.mock(StorageBroker.class);
        this.tld = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        this.customTld = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        this.gridsetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true)));
        this.httpsUrlMangler = new URLMangler(){
            final Pattern PATTERN = Pattern.compile("http");

            public String buildURL(String baseURL, String contextPath, String path) {
                String url = StringUtils.strip((String)baseURL, (String)"/") + "/" + StringUtils.strip((String)contextPath, (String)"/") + "/" + StringUtils.stripStart((String)path, (String)"/");
                url = url.startsWith("https") ? url : this.PATTERN.matcher(url).replaceFirst("https");
                return url;
            }
        };
        this.customFactory = new TMSCustomFactoryTest(this.customTld, this.gridsetBroker, this.httpsUrlMangler, TMSCustomFactoryTest.getCatalogInstance());
    }

    private static TileLayer mockTileLayer(TileLayerDispatcher tld, GridSetBroker gridsetBroker, String layerName, List<String> gridSetNames, List<ParameterFilter> parameterFilters) throws Exception {
        return TMSServiceTest.mockTileLayer(tld, gridsetBroker, layerName, gridSetNames, parameterFilters, true);
    }

    private static TileLayer mockTileLayer(TileLayerDispatcher tld, GridSetBroker gridsetBroker, String layerName, List<String> gridSetNames, List<ParameterFilter> parameterFilters, boolean advertised) throws Exception {
        TileLayer tileLayer = (TileLayer)Mockito.mock(TileLayer.class);
        Mockito.when((Object)tld.getTileLayer((String)ArgumentMatchers.eq((Object)layerName))).thenReturn((Object)tileLayer);
        Mockito.when((Object)tileLayer.getName()).thenReturn((Object)layerName);
        Mockito.when((Object)tileLayer.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)tileLayer.isAdvertised()).thenReturn((Object)advertised);
        MimeType mimeType1 = MimeType.createFromFormat((String)"image/png");
        MimeType mimeType2 = MimeType.createFromFormat((String)"image/jpeg");
        Mockito.when((Object)tileLayer.getMimeTypes()).thenReturn(Arrays.asList(mimeType1, mimeType2));
        HashMap<String, GridSubset> subsets = new HashMap<String, GridSubset>();
        HashMap<SRS, ArrayList<GridSubset>> bySrs = new HashMap<SRS, ArrayList<GridSubset>>();
        GridSetBroker broker = gridsetBroker;
        for (String gsetName : gridSetNames) {
            GridSet gridSet = broker.get(gsetName);
            XMLGridSubset xmlGridSubset = new XMLGridSubset();
            String gridSetName = gridSet.getName();
            xmlGridSubset.setGridSetName(gridSetName);
            GridSubset gridSubSet = xmlGridSubset.getGridSubSet(broker);
            subsets.put(gsetName, gridSubSet);
            ArrayList<GridSubset> list = (ArrayList<GridSubset>)bySrs.get(gridSet.getSrs());
            if (list == null) {
                list = new ArrayList<GridSubset>();
                bySrs.put(gridSet.getSrs(), list);
            }
            list.add(gridSubSet);
            Mockito.when((Object)tileLayer.getGridSubset((String)ArgumentMatchers.eq((Object)gsetName))).thenReturn((Object)gridSubSet);
        }
        for (SRS srs : bySrs.keySet()) {
            List list = (List)bySrs.get(srs);
            Mockito.when((Object)tileLayer.getGridSubsetsForSRS((SRS)ArgumentMatchers.eq((Object)srs))).thenReturn((Object)list);
        }
        Mockito.when((Object)tileLayer.getGridSubsets()).thenReturn(subsets.keySet());
        Mockito.when((Object)tileLayer.getParameterFilters()).thenReturn(parameterFilters);
        for (String gsetName : gridSetNames) {
            Assert.assertTrue((boolean)tileLayer.getGridSubsets().contains(gsetName));
            Assert.assertNotNull((Object)tileLayer.getGridSubset(gsetName));
        }
        return tileLayer;
    }

    @Test
    public void testTileMapServiceDocument() throws Exception {
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new TMSService(this.sb, this.tld, this.gridsetBroker, (RuntimeStats)Mockito.mock(RuntimeStats.class));
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getPathInfo()).thenReturn((Object)"/service/tms/1.0.0");
        Mockito.when((Object)req.getRequestURI()).thenReturn((Object)"/mycontext/service/tms/1.0.0");
        Mockito.when((Object)req.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)req.getServerName()).thenReturn((Object)"localhost");
        Mockito.when((Object)req.getServerPort()).thenReturn((Object)8080);
        Mockito.when((Object)req.getContextPath()).thenReturn((Object)"/mycontext");
        Mockito.when((Object)req.getRequestURL()).thenReturn((Object)new StringBuffer("http://localhost:8080/mycontext/service/tms/1.0.0"));
        List<String> gridSetNames = Arrays.asList("EPSG:4326");
        TileLayer tileLayer = TMSServiceTest.mockTileLayer(this.tld, this.gridsetBroker, "mockLayer", gridSetNames, Collections.emptyList());
        Mockito.when((Object)this.tld.getLayerList()).thenReturn(Arrays.asList(tileLayer));
        Mockito.when((Object)this.tld.getLayerListFiltered()).thenReturn(Arrays.asList(tileLayer));
        ConveyorTile conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        Assert.assertNotNull((Object)conv);
        String layerName = conv.getLayerId();
        Assert.assertNull((Object)layerName);
        Assert.assertEquals((Object)Conveyor.RequestHandler.SERVICE, (Object)conv.reqHandler);
        this.service.handleRequest((Conveyor)conv);
        String result = resp.getContentAsString();
        Assert.assertTrue((boolean)result.contains("mockLayer"));
        Document doc = XMLUnit.buildTestDocument((String)result);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//TileMapService[contains(@services,'http://localhost:8080/mycontext/')])", doc));
        Assert.assertEquals((Object)"2", (Object)xpath.evaluate("count(//TileMap[@title='mockLayer'])", doc));
        Assert.assertEquals((Object)"2", (Object)xpath.evaluate("count(//TileMap[@title='mockLayer'][@srs='EPSG:4326'])", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//TileMap[@title='mockLayer'][contains(@href,'jpeg')])", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//TileMap[@title='mockLayer'][contains(@href,'png')])", doc));
        Assert.assertEquals((Object)"0", (Object)xpath.evaluate("count(//TileMap[@title='mockLayer'][contains(@href,'jpeg-png')])", doc));
    }

    @Test
    public void testTMSDocumentsWithCustomFactory() throws Exception {
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        this.service = new TMSService(this.sb, (RuntimeStats)Mockito.mock(RuntimeStats.class), gwcd, this.customFactory);
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getPathInfo()).thenReturn((Object)"/service/tms/1.0.0");
        Mockito.when((Object)req.getRequestURI()).thenReturn((Object)"/mycontext/service/tms/1.0.0");
        Mockito.when((Object)req.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)req.getServerName()).thenReturn((Object)"localhost");
        Mockito.when((Object)req.getServerPort()).thenReturn((Object)8080);
        Mockito.when((Object)req.getContextPath()).thenReturn((Object)"/mycontext");
        Mockito.when((Object)req.getRequestURL()).thenReturn((Object)new StringBuffer("http://localhost:8080/mycontext/service/tms/1.0.0"));
        ConveyorTile conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        Assert.assertNotNull((Object)conv);
        String layerName = conv.getLayerId();
        Assert.assertNull((Object)layerName);
        Assert.assertEquals((Object)Conveyor.RequestHandler.SERVICE, (Object)conv.reqHandler);
        this.service.handleRequest((Conveyor)conv);
        String result = resp.getContentAsString();
        Assert.assertFalse((boolean)result.contains("customLayer1"));
        Assert.assertTrue((boolean)result.contains("customLayer2"));
        Document doc = XMLUnit.buildTestDocument((String)result);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//TileMapService[contains(@services,'https://localhost:8080/mycontext/')])", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//TileMap[@title='Custom Layer2'])", doc));
        Assert.assertEquals((Object)"1", (Object)xpath.evaluate("count(//TileMap[@title='Custom Layer2'][contains(@href,'jpeg-png')])", doc));
        Assert.assertEquals((Object)"0", (Object)xpath.evaluate("count(//TileMap[@title='Custom Layer1'])", doc));
        req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        resp = new MockHttpServletResponse();
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)req.getServerName()).thenReturn((Object)"localhost");
        Mockito.when((Object)req.getServerPort()).thenReturn((Object)8080);
        Mockito.when((Object)req.getContextPath()).thenReturn((Object)"/mycontext");
        Mockito.when((Object)req.getRequestURL()).thenReturn((Object)new StringBuffer("http://localhost:8080/mycontext/service/tms/1.0.0/customLayer2@EPSG:4326@jpeg-png"));
        Mockito.when((Object)req.getPathInfo()).thenReturn((Object)"/service/tms/1.0.0/customLayer2@EPSG:4326@jpeg-png");
        Mockito.when((Object)req.getRequestURI()).thenReturn((Object)"/mycontext/service/tms/1.0.0/customLayer2@EPSG:4326@jpeg-png");
        conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        this.service.handleRequest((Conveyor)conv);
        result = resp.getContentAsString().replace("\n\n", "\n");
        doc = XMLUnit.buildTestDocument((String)result);
        xpath = XMLUnit.newXpathEngine();
        Assert.assertEquals((Object)"22", (Object)xpath.evaluate("count(//TileSet[contains(@href,'customLayer2')])", doc));
    }

    @Test
    public void testGetTile() throws Exception {
        this.testGetTile(false);
    }

    @Test
    public void testGetTileFlipped() throws Exception {
        this.testGetTile(true);
    }

    private void testGetTile(boolean flipY) throws Exception {
        GeoWebCacheDispatcher gwcd = (GeoWebCacheDispatcher)Mockito.mock(GeoWebCacheDispatcher.class);
        Mockito.when((Object)gwcd.getServletPrefix()).thenReturn(null);
        this.service = new TMSService(this.sb, (RuntimeStats)Mockito.mock(RuntimeStats.class), gwcd, this.customFactory);
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse resp = new MockHttpServletResponse();
        List<String> gridSetNames = Arrays.asList("EPSG:4326");
        TileLayer tileLayer = TMSServiceTest.mockTileLayer(this.customFactory.tld, this.customFactory.gsb, "customLayer2", gridSetNames, null);
        Mockito.when((Object)this.customFactory.tld.getLayerList()).thenReturn(Arrays.asList(tileLayer));
        int level = 3;
        boolean column = true;
        int row = 2;
        String tilePath = "customLayer2@EPSG%3A4326@jpeg-png/3/1/2.jpeg-png";
        Mockito.when((Object)req.getRequestURL()).thenReturn((Object)new StringBuffer("http://localhost:8080/mycontext/service/tms/1.0.0/" + tilePath));
        Mockito.when((Object)req.getPathInfo()).thenReturn((Object)("/service/tms/1.0.0/" + tilePath));
        Mockito.when((Object)req.getRequestURI()).thenReturn((Object)("/mycontext/service/tms/1.0.0/" + tilePath));
        Mockito.when((Object)req.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)req.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)req.getServerName()).thenReturn((Object)"localhost");
        Mockito.when((Object)req.getServerPort()).thenReturn((Object)8080);
        Mockito.when((Object)req.getContextPath()).thenReturn((Object)"/mycontext");
        Enumeration<String> parameterNames = null;
        String flipParameter = "false";
        if (flipY) {
            String[] paramNames = new String[]{"random", "flipY"};
            parameterNames = Collections.enumeration(Arrays.asList(paramNames));
            flipParameter = "true";
        }
        Mockito.when((Object)req.getParameterNames()).thenReturn(parameterNames);
        Mockito.when((Object)req.getParameter("flipY")).thenReturn((Object)flipParameter);
        ConveyorTile conv = this.service.getConveyor(req, (HttpServletResponse)resp);
        Assert.assertNotNull((Object)conv);
        MatcherAssert.assertThat((Object)conv, (Matcher)CoreMatchers.instanceOf(ConveyorTile.class));
        ConveyorTile tile = conv;
        long[] tileIndex = tile.getTileIndex();
        Assert.assertEquals((long)1L, (long)tileIndex[0]);
        Assert.assertEquals((long)2L, (long)(flipY ? (long)((int)Math.pow(2.0, 3.0)) - tileIndex[1] - 1L : tileIndex[1]));
        Assert.assertEquals((long)3L, (long)tileIndex[2]);
    }

    private static class TMSCustomFactoryTest
    extends TMSDocumentFactory {
        private static final List<CustomLayerImplementation> CATALOG_INSTANCE = new ArrayList<CustomLayerImplementation>(2);
        private List<CustomLayerImplementation> customCatalogLayers;

        public static List<CustomLayerImplementation> getCatalogInstance() {
            return CATALOG_INSTANCE;
        }

        protected TMSCustomFactoryTest(TileLayerDispatcher tld, GridSetBroker gsb, URLMangler urlMangler, List<CustomLayerImplementation> customCatalogLayers) throws Exception {
            super(tld, gsb, urlMangler, "tilemapservice", StandardCharsets.UTF_8);
            List<String> gridSetNames = Arrays.asList("EPSG:4326");
            TileLayer tileLayer = TMSServiceTest.mockTileLayer(tld, gsb, "customLayer2", gridSetNames, Collections.emptyList());
            Mockito.when((Object)tld.getLayerList()).thenReturn(Arrays.asList(tileLayer));
            this.customCatalogLayers = customCatalogLayers;
        }

        protected String getTileMapServiceDoc(String baseUrl, String contextPath) {
            StringBuilder str = new StringBuilder();
            str.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            str.append("<TileMapService version=\"1.0.0\" services=\"" + this.urlMangler.buildURL(baseUrl, contextPath, "") + "\">\n");
            str.append("  <Title>Custom Tile Map Service</Title>\n");
            str.append("  <Abstract>A Custom Tile Map Service served by GeoWebCache</Abstract>\n");
            str.append("  <TileMaps>\n");
            for (CustomLayerImplementation layer : this.customCatalogLayers) {
                if (!layer.isAuthorized) continue;
                for (String format : layer.formats) {
                    this.tileMapsForLayer(str, layer, format, baseUrl, contextPath);
                }
            }
            str.append("  </TileMaps>\n");
            str.append("</TileMapService>\n");
            return str.toString();
        }

        protected void tileMapsForLayer(StringBuilder str, CustomLayerImplementation layer, String format, String baseUrl, String contextPath) {
            str.append("    <TileMap\n");
            str.append("      title=\"").append(layer.title).append("\"\n");
            str.append("      srs=\"").append("4326").append("\"\n");
            str.append("      profile=\"global-geodetic");
            str.append("\"\n");
            str.append("      href=\"");
            String tileMapName = layer.name + "@EPSG:4326@" + format;
            String url = this.urlMangler.buildURL(baseUrl, contextPath, "service/tms/1.0.0/" + tileMapName);
            str.append(url).append("\" />\n");
        }

        static {
            CATALOG_INSTANCE.add(new CustomLayerImplementation("customLayer1", "Custom Layer1", false, null));
            CATALOG_INSTANCE.add(new CustomLayerImplementation("customLayer2", "Custom Layer2", true, Arrays.asList("jpeg-png")));
        }

        static class CustomLayerImplementation {
            private String name;
            private String title;
            private boolean isAuthorized;
            private List<String> formats;

            public CustomLayerImplementation(String name, String title, boolean isAuthorized, List<String> formats) {
                this.name = name;
                this.title = title;
                this.isAuthorized = isAuthorized;
                this.formats = formats;
            }
        }
    }
}

