/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.converter;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.ContextualConfigurationProvider;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.config.XMLGridSet;
import org.geowebcache.grid.GridSet;
import org.geowebcache.io.GeoWebCacheXStream;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.rest.converter.ServerConfigurationPOJO;
import org.geowebcache.rest.converter.XStreamListAliasWrapper;
import org.geowebcache.rest.exception.RestException;
import org.geowebcache.util.ApplicationContextProvider;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.web.context.WebApplicationContext;

public class GWCConverter<T>
extends AbstractHttpMessageConverter<T>
implements HttpMessageConverter<T> {
    private final WebApplicationContext context;
    public final List<Class> supportedClasses = Collections.unmodifiableList(Arrays.asList(BlobStoreInfo.class, GridSet.class, TileLayer.class, ServerConfigurationPOJO.class));

    public GWCConverter(ApplicationContextProvider appCtx) {
        super(new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML, MediaType.TEXT_XML});
        this.context = appCtx.getApplicationContext();
    }

    private XStream configureXStream(XStream xs) {
        xs.alias("global", ServerConfigurationPOJO.class);
        return xs;
    }

    protected boolean supports(Class<?> clazz) {
        for (Class supportedClass : this.supportedClasses) {
            if (!supportedClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return XStreamListAliasWrapper.class.isAssignableFrom(clazz);
    }

    protected T readInternal(Class<? extends T> clazz, HttpInputMessage httpInputMessage) throws IOException, HttpMessageNotReadableException {
        MediaType contentType = httpInputMessage.getHeaders().getContentType();
        XStream xs = this.configureXStream(XMLConfiguration.getConfiguredXStreamWithContext((XStream)new GeoWebCacheXStream((HierarchicalStreamDriver)new DomDriver()), (WebApplicationContext)this.context, (ContextualConfigurationProvider.Context)ContextualConfigurationProvider.Context.REST));
        try {
            Object object;
            if (MediaType.APPLICATION_XML.isCompatibleWith(contentType) || MediaType.TEXT_XML.isCompatibleWith(contentType)) {
                object = xs.fromXML(httpInputMessage.getBody());
            } else if (MediaType.APPLICATION_JSON.isCompatibleWith(contentType)) {
                JettisonMappedXmlDriver driver = new JettisonMappedXmlDriver();
                HierarchicalStreamReader hsr = driver.createReader(httpInputMessage.getBody());
                StringWriter writer = new StringWriter();
                new HierarchicalStreamCopier().copy(hsr, (HierarchicalStreamWriter)new PrettyPrintWriter((Writer)writer));
                writer.close();
                object = xs.fromXML(writer.toString());
            } else {
                throw new RestException("Unknown or missing format", HttpStatus.UNSUPPORTED_MEDIA_TYPE);
            }
            if (object instanceof XMLGridSet) {
                return (T)((XMLGridSet)object).makeGridSet();
            }
            return (T)object;
        }
        catch (ConversionException xstreamExceptionWrapper) {
            Throwable cause = xstreamExceptionWrapper.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause != null) {
                throw new RestException(cause.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR, cause);
            }
            throw new RestException(xstreamExceptionWrapper.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR, xstreamExceptionWrapper);
        }
    }

    protected void writeInternal(T object, HttpOutputMessage httpOutputMessage) throws IOException, HttpMessageNotWritableException {
        block12: {
            MediaType contentType = httpOutputMessage.getHeaders().getContentType();
            try (OutputStreamWriter outputWriter = new OutputStreamWriter(httpOutputMessage.getBody());){
                if (MediaType.APPLICATION_XML.isCompatibleWith(contentType) || MediaType.TEXT_XML.isCompatibleWith(contentType)) {
                    GeoWebCacheXStream xs = new GeoWebCacheXStream();
                    Object xsObject = object;
                    if (object instanceof XStreamListAliasWrapper) {
                        XStreamListAliasWrapper wrapper = (XStreamListAliasWrapper)object;
                        xsObject = wrapper.object;
                        xs.alias(wrapper.alias + "s", wrapper.collectionClass);
                        xs.registerConverter(wrapper.createConverter());
                    } else if (object instanceof GridSet) {
                        xsObject = new XMLGridSet((GridSet)object);
                    }
                    xs = this.configureXStream(XMLConfiguration.getConfiguredXStreamWithContext((XStream)xs, (WebApplicationContext)this.context, (ContextualConfigurationProvider.Context)ContextualConfigurationProvider.Context.REST));
                    String xmlText = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + xs.toXML(xsObject);
                    outputWriter.write(xmlText);
                    break block12;
                }
                if (MediaType.APPLICATION_JSON.isCompatibleWith(contentType)) {
                    XStream xs = this.configureXStream(XMLConfiguration.getConfiguredXStreamWithContext((XStream)new GeoWebCacheXStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver()), (WebApplicationContext)this.context, (ContextualConfigurationProvider.Context)ContextualConfigurationProvider.Context.REST));
                    Object jsonObject = object instanceof XStreamListAliasWrapper ? new JSONArray(((XStreamListAliasWrapper)object).object) : (object instanceof GridSet ? new JSONObject(xs.toXML((Object)new XMLGridSet((GridSet)object))) : new JSONObject(xs.toXML(object)));
                    outputWriter.write(jsonObject.toString());
                    break block12;
                }
                throw new RestException("Unknown or missing format", HttpStatus.UNSUPPORTED_MEDIA_TYPE);
            }
            catch (JSONException e) {
                throw new IOException(e);
            }
        }
    }
}

