/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.controller;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.ContextualConfigurationProvider;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.io.GeoWebCacheXStream;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.DefaultStorageBroker;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.blobstore.memory.CacheStatistics;
import org.geowebcache.storage.blobstore.memory.MemoryBlobStore;
import org.geowebcache.util.ApplicationContextProvider;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.WebApplicationContext;

@Component
@RestController
@RequestMapping(path={"${gwc.context.suffix:}/rest"})
public class MemoryCacheController {
    public static Logger log = Logging.getLogger((String)MemoryCacheController.class.getName());
    @Autowired
    StorageBroker broker;
    private WebApplicationContext context;
    private BlobStore store;

    @Autowired
    public MemoryCacheController(ApplicationContextProvider appCtx) {
        this.context = appCtx == null ? null : appCtx.getApplicationContext();
    }

    public void setStorageBroker(StorageBroker broker) {
        this.broker = broker;
    }

    public void setContext(WebApplicationContext context) {
        this.context = context;
    }

    public void setBlobStore(BlobStore store) {
        this.store = store;
    }

    @RequestMapping(value={"/statistics"}, method={RequestMethod.GET})
    public ResponseEntity<?> doGet(HttpServletRequest request) {
        ResponseEntity entity;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Getting BlobStore from the storage broker");
        }
        if (this.broker instanceof DefaultStorageBroker) {
            this.store = ((DefaultStorageBroker)this.broker).getBlobStore();
        }
        if (this.store != null && this.store instanceof MemoryBlobStore) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Memory Blobstore found, now getting statistics");
            }
            MemoryBlobStore memoryStore = (MemoryBlobStore)this.store;
            CacheStatistics stats = memoryStore.getCacheStatistics();
            CacheStatistics statistics = new CacheStatistics(stats);
            if (request.getPathInfo().contains("json")) {
                try {
                    entity = this.getJsonRepresentation(statistics);
                }
                catch (JSONException e) {
                    entity = new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            } else {
                entity = this.getXmlRepresentation(statistics);
            }
        } else {
            entity = new ResponseEntity((Object)("No statistics available for the current BlobStore: " + String.valueOf(this.store != null ? this.store.getClass() : null)), HttpStatus.NOT_FOUND);
        }
        return entity;
    }

    private ResponseEntity<?> getJsonRepresentation(CacheStatistics stats) throws JSONException {
        XStream xs = XMLConfiguration.getConfiguredXStreamWithContext((XStream)new GeoWebCacheXStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver()), (WebApplicationContext)this.context, (ContextualConfigurationProvider.Context)ContextualConfigurationProvider.Context.REST);
        JSONObject obj = new JSONObject(xs.toXML((Object)stats));
        return new ResponseEntity((Object)obj.toString(), HttpStatus.OK);
    }

    private ResponseEntity<?> getXmlRepresentation(CacheStatistics stats) {
        XStream xStream = MemoryCacheController.getConfiguredXStream((XStream)new GeoWebCacheXStream());
        String xmlText = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + xStream.toXML((Object)stats);
        return new ResponseEntity((Object)xmlText, HttpStatus.OK);
    }

    public static XStream getConfiguredXStream(XStream xs) {
        xs.setMode(1001);
        xs.alias("gwcInMemoryCacheStatistics", CacheStatistics.class);
        return xs;
    }
}

