/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.rest.webresources.WebResourceBundle;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Component
@RestController
@RequestMapping(path={"${gwc.context.suffix:}/rest"})
public class ByteStreamController {
    private static Logger log = Logging.getLogger((String)ByteStreamController.class.getName());
    volatile WebResourceBundle bundle;
    private static final WebResourceBundle DEFAULT_BUNDLE = WebResourceBundle.class::getResource;
    static final Pattern UNSAFE_RESOURCE = Pattern.compile("^/|/\\.\\./|^\\.\\./|\\.class$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL getResource(String path) {
        URL resource;
        if (this.bundle == null) {
            ByteStreamController byteStreamController = this;
            synchronized (byteStreamController) {
                if (this.bundle == null) {
                    List result = GeoWebCacheExtensions.extensions(WebResourceBundle.class);
                    if (result.isEmpty()) {
                        this.bundle = DEFAULT_BUNDLE;
                    } else {
                        if (result.size() > 1) {
                            log.warning("Multiple web resource bundles present, using " + ((WebResourceBundle)result.get(0)).getClass().getName());
                        }
                        this.bundle = (WebResourceBundle)result.get(0);
                    }
                }
            }
        }
        if ((resource = (URL)this.bundle.apply(path)) == null && this.bundle != DEFAULT_BUNDLE) {
            resource = (URL)DEFAULT_BUNDLE.apply(path);
        }
        return resource;
    }

    String getFileName(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (path.indexOf("/rest/web") != 0) {
            path = path.substring(path.indexOf("/rest/web"));
        }
        return path.substring("/rest/web/".length());
    }

    @RequestMapping(value={"/web/**"}, method={RequestMethod.GET})
    ResponseEntity<?> doGet(HttpServletRequest request, HttpServletResponse response) {
        String filename;
        try {
            filename = URLDecoder.decode(this.getFileName(request), "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw new IllegalStateException("Could not decode encoding UTF-8", e1);
        }
        if (UNSAFE_RESOURCE.matcher(filename).find()) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        URL resource = this.getResource(filename);
        if (resource == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        String[] filenameParts = filename.split("\\.");
        String extension = filenameParts[filenameParts.length - 1];
        MimeType mime = null;
        try {
            mime = MimeType.createFromExtension((String)extension);
        }
        catch (MimeException e) {
            return new ResponseEntity((Object)("Unable to create MimeType for " + extension), HttpStatus.INTERNAL_SERVER_ERROR);
        }
        response.setContentType(mime.getFormat());
        try (InputStream inputStream = resource.openStream();
             ServletOutputStream outputStream = response.getOutputStream();){
            StreamUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            return new ResponseEntity((Object)"Internal error", HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(HttpStatus.OK);
    }
}

