/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.InputStream;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.GeoWebCacheConfiguration;
import org.geowebcache.config.TileLayerConfiguration;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.io.GeoWebCacheXStream;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.rest.filter.WMSRasterFilterUpdate;
import org.geowebcache.rest.filter.XmlFilterUpdate;

public class XMLConfiguration {
    private static XStream getConfiguredXStream(XStream xs) {
        xs.allowTypeHierarchy(TileLayer.class);
        xs.allowTypeHierarchy(ParameterFilter.class);
        xs.allowTypeHierarchy(RequestFilter.class);
        xs.allowTypeHierarchy(BlobStoreInfo.class);
        xs.allowTypeHierarchy(TileLayerConfiguration.class);
        xs.allowTypesByWildcard(new String[]{"org.geowebcache.**"});
        xs.setMode(1001);
        xs.alias("gwcConfiguration", GeoWebCacheConfiguration.class);
        xs.useAttributeFor(GeoWebCacheConfiguration.class, "xmlns_xsi");
        xs.aliasField("xmlns:xsi", GeoWebCacheConfiguration.class, "xmlns_xsi");
        xs.useAttributeFor(GeoWebCacheConfiguration.class, "xmlns");
        xs.alias("wmsRasterFilterUpdate", WMSRasterFilterUpdate.class);
        return xs;
    }

    public static XmlFilterUpdate parseXMLFilterUpdate(InputStream in) {
        XStream xs = XMLConfiguration.getConfiguredXStream((XStream)new GeoWebCacheXStream((HierarchicalStreamDriver)new DomDriver()));
        XmlFilterUpdate fu = (XmlFilterUpdate)xs.fromXML(in);
        return fu;
    }
}

