/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.seed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.easymock.EasyMock;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.ConfigurationResourceProvider;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.MockConfigurationResourceProvider;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.rest.controller.MassTruncateController;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.storage.StorageBroker;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.http.MediaType;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"file*:/webapp/WEB-INF/web.xml", "file*:/webapp/WEB-INF/geowebcache-servlet.xml"})
public class MassTruncateControllerTest {
    private MockMvc mockMvc;
    MassTruncateController mtc;

    @Before
    public void setup() throws GeoWebCacheException {
        GridSetBroker gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false)));
        XMLConfiguration xmlConfig = this.loadXMLConfig();
        xmlConfig.setGridSetBroker(gridSetBroker);
        xmlConfig.afterPropertiesSet();
        this.mtc = new MassTruncateController(null);
        this.mockMvc = MockMvcBuilders.standaloneSetup((Object[])new Object[]{this.mtc}).build();
    }

    @Test
    public void testTruncateLayer() throws Exception {
        HashSet<String> layer1GridSet = new HashSet<String>(Arrays.asList("test_grid1", "test_grid2"));
        String layerName = "test";
        TileLayer tl1 = (TileLayer)EasyMock.createMock(TileLayer.class);
        EasyMock.expect((Object)tl1.getGridSubsets()).andReturn(layer1GridSet).anyTimes();
        String requestBody = "<truncateLayer><layerName>" + layerName + "</layerName></truncateLayer>";
        TileBreeder tb = (TileBreeder)EasyMock.createMock(TileBreeder.class);
        EasyMock.expect((Object)tb.findTileLayer(layerName)).andReturn((Object)tl1);
        StorageBroker sb = (StorageBroker)EasyMock.createMock(StorageBroker.class);
        for (String grid : layer1GridSet) {
            EasyMock.expect((Object)sb.deleteByGridSetId(layerName, grid)).andReturn((Object)true);
        }
        EasyMock.replay((Object[])new Object[]{tl1});
        EasyMock.replay((Object[])new Object[]{sb});
        EasyMock.replay((Object[])new Object[]{tb});
        this.mtc.setStorageBroker(sb);
        this.mtc.setTileBreeder(tb);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/masstruncate", (Object[])new Object[0]).contentType(MediaType.TEXT_XML).content(requestBody).contextPath("")).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
        EasyMock.verify((Object[])new Object[]{sb});
    }

    @Test
    public void testTruncateLayerTwice() throws Exception {
        HashSet<String> layer1GridSet = new HashSet<String>(Arrays.asList("test_grid1", "test_grid2"));
        String layerName = "test";
        TileLayer tileLayer = (TileLayer)EasyMock.createMock(TileLayer.class);
        EasyMock.expect((Object)tileLayer.getName()).andReturn((Object)layerName).anyTimes();
        EasyMock.expect((Object)tileLayer.getGridSubsets()).andReturn(layer1GridSet);
        EasyMock.expect((Object)tileLayer.getGridSubsets()).andReturn(new HashSet());
        EasyMock.replay((Object[])new Object[]{tileLayer});
        String requestBody = "<truncateLayer><layerName>" + layerName + "</layerName></truncateLayer>";
        StorageBroker sb = (StorageBroker)EasyMock.createMock(StorageBroker.class);
        for (String grid : layer1GridSet) {
            EasyMock.expect((Object)sb.deleteByGridSetId(layerName, grid)).andReturn((Object)true);
        }
        EasyMock.replay((Object[])new Object[]{sb});
        TileBreeder tb = (TileBreeder)EasyMock.createMock(TileBreeder.class);
        EasyMock.expect((Object)tb.findTileLayer(layerName)).andReturn((Object)tileLayer).times(2);
        EasyMock.replay((Object[])new Object[]{tb});
        this.mtc.setStorageBroker(sb);
        this.mtc.setTileBreeder(tb);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/masstruncate", (Object[])new Object[0]).contentType(MediaType.TEXT_XML).content(requestBody).contextPath("")).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/masstruncate", (Object[])new Object[0]).contentType(MediaType.TEXT_XML).content(requestBody).contextPath("")).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
        EasyMock.verify((Object[])new Object[]{sb});
    }

    @Test
    public void testTruncateNonExistingLayer() throws Exception {
        String layerName = "test";
        String requestBody = "<truncateLayer><layerName>" + layerName + "</layerName></truncateLayer>";
        StorageBroker sb = (StorageBroker)EasyMock.createMock(StorageBroker.class);
        EasyMock.replay((Object[])new Object[]{sb});
        TileBreeder tb = (TileBreeder)EasyMock.createMock(TileBreeder.class);
        EasyMock.expect((Object)tb.findTileLayer(layerName)).andThrow((Throwable)new GeoWebCacheException("Layer not found"));
        EasyMock.replay((Object[])new Object[]{tb});
        this.mtc.setStorageBroker(sb);
        this.mtc.setTileBreeder(tb);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/masstruncate", (Object[])new Object[0]).contentType(MediaType.TEXT_XML).content(requestBody).contextPath("")).andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.content().string(CoreMatchers.containsString((String)"Could not find layer test")));
        EasyMock.verify((Object[])new Object[]{sb});
    }

    @Test
    public void testGetMassTruncate() throws Exception {
        MvcResult result = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/masstruncate", (Object[])new Object[0]).contentType(MediaType.APPLICATION_ATOM_XML).contextPath("")).andReturn();
        Assert.assertEquals((long)200L, (long)result.getResponse().getStatus());
    }

    @Test
    public void testTruncateAllLayers() throws Exception {
        HashSet<String> layer1GridSet = new HashSet<String>(Arrays.asList("test1_grid1", "test1_grid2"));
        HashSet<String> layer2GridSet = new HashSet<String>(Arrays.asList("test22_grid1", "test22_grid2"));
        String layerName = "test11";
        String layerName2 = "test22";
        TileLayer tl1 = (TileLayer)EasyMock.createMock(TileLayer.class);
        TileLayer tl2 = (TileLayer)EasyMock.createMock(TileLayer.class);
        EasyMock.expect((Object)tl1.getName()).andReturn((Object)layerName).anyTimes();
        EasyMock.expect((Object)tl1.getGridSubsets()).andReturn(layer1GridSet).anyTimes();
        EasyMock.expect((Object)tl2.getName()).andReturn((Object)layerName2).anyTimes();
        EasyMock.expect((Object)tl2.getGridSubsets()).andReturn(layer2GridSet).anyTimes();
        EasyMock.replay((Object[])new Object[]{tl1});
        EasyMock.replay((Object[])new Object[]{tl2});
        ArrayList<TileLayer> mockList = new ArrayList<TileLayer>();
        mockList.add(tl1);
        mockList.add(tl2);
        String requestBody = "<truncateAll></truncateAll>";
        TileBreeder tb = (TileBreeder)EasyMock.createMock(TileBreeder.class);
        EasyMock.expect((Object)tb.getLayers()).andReturn(mockList);
        StorageBroker sb = (StorageBroker)EasyMock.createMock(StorageBroker.class);
        for (String grid : layer1GridSet) {
            EasyMock.expect((Object)sb.deleteByGridSetId(layerName, grid)).andReturn((Object)true);
        }
        for (String grid : layer2GridSet) {
            EasyMock.expect((Object)sb.deleteByGridSetId(layerName2, grid)).andReturn((Object)true);
        }
        EasyMock.replay((Object[])new Object[]{sb});
        EasyMock.replay((Object[])new Object[]{tb});
        this.mtc.setStorageBroker(sb);
        this.mtc.setTileBreeder(tb);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/masstruncate", (Object[])new Object[0]).contentType(MediaType.TEXT_XML).content(requestBody).contextPath("")).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
        EasyMock.verify((Object[])new Object[]{sb});
    }

    @Test
    public void testTruncateAllLayersFromHTMLForm() throws Exception {
        HashSet<String> layer1GridSet = new HashSet<String>(Arrays.asList("test1_grid1", "test1_grid2"));
        HashSet<String> layer2GridSet = new HashSet<String>(Arrays.asList("test2_grid1", "test2_grid2"));
        String layerName = "test1";
        String layerName2 = "test2";
        TileLayer tl1 = (TileLayer)EasyMock.createMock(TileLayer.class);
        TileLayer tl2 = (TileLayer)EasyMock.createMock(TileLayer.class);
        EasyMock.expect((Object)tl1.getName()).andReturn((Object)layerName).anyTimes();
        EasyMock.expect((Object)tl1.getGridSubsets()).andReturn(layer1GridSet).anyTimes();
        EasyMock.expect((Object)tl2.getName()).andReturn((Object)layerName2).anyTimes();
        EasyMock.expect((Object)tl2.getGridSubsets()).andReturn(layer2GridSet).anyTimes();
        EasyMock.replay((Object[])new Object[]{tl1});
        EasyMock.replay((Object[])new Object[]{tl2});
        ArrayList<TileLayer> mockList = new ArrayList<TileLayer>();
        mockList.add(tl1);
        mockList.add(tl2);
        TileBreeder tb = (TileBreeder)EasyMock.createMock(TileBreeder.class);
        EasyMock.expect((Object)tb.getLayers()).andReturn(mockList);
        StorageBroker sb = (StorageBroker)EasyMock.createMock(StorageBroker.class);
        for (String grid : layer1GridSet) {
            EasyMock.expect((Object)sb.deleteByGridSetId(layerName, grid)).andReturn((Object)true);
        }
        for (String grid : layer2GridSet) {
            EasyMock.expect((Object)sb.deleteByGridSetId(layerName2, grid)).andReturn((Object)true);
        }
        EasyMock.replay((Object[])new Object[]{sb});
        EasyMock.replay((Object[])new Object[]{tb});
        this.mtc.setStorageBroker(sb);
        this.mtc.setTileBreeder(tb);
        String requestBody = "<truncateAll>=</truncateAll>";
        MvcResult result = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/masstruncate", (Object[])new Object[0]).contentType(MediaType.APPLICATION_FORM_URLENCODED).content(requestBody).contextPath("")).andExpect(MockMvcResultMatchers.status().is2xxSuccessful()).andReturn();
        Assert.assertTrue((boolean)result.getResponse().getContentAsString().contains("Truncated Layers:test1,test2"));
    }

    private XMLConfiguration loadXMLConfig() {
        XMLConfiguration xmlConfig = null;
        try {
            xmlConfig = new XMLConfiguration(null, (ConfigurationResourceProvider)new MockConfigurationResourceProvider(() -> XMLConfiguration.class.getResourceAsStream("geowebcache_125.xml")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xmlConfig;
    }
}

