/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.filter;

import java.util.LinkedList;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.ConfigurationResourceProvider;
import org.geowebcache.config.MockConfigurationResourceProvider;
import org.geowebcache.config.MockGridSetConfiguration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.rest.controller.FilterUpdateController;
import org.junit.Before;
import org.junit.Test;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

public class FilterUpdateControllerTest {
    private MockMvc mockMvc;
    TileLayerDispatcher tld;
    FilterUpdateController fc;

    @Before
    public void setup() throws GeoWebCacheException {
        BoundingBox extent = new BoundingBox(0.0, 0.0, 1.0E7, 1.0E7);
        boolean alignTopLeft = false;
        int levels = 10;
        Double metersPerUnit = 1.0;
        double pixelSize = 0.0028;
        int tileWidth = 256;
        int tileHeight = 256;
        boolean yCoordinateFirst = false;
        GridSet gridSet = GridSetFactory.createGridSet((String)"EPSG:3395", (SRS)SRS.getSRS((String)"EPSG:3395"), (BoundingBox)extent, (boolean)alignTopLeft, (int)levels, (Double)metersPerUnit, (double)pixelSize, (int)tileWidth, (int)tileHeight, (boolean)yCoordinateFirst);
        GridSetBroker gridSetBroker = new GridSetBroker(MockGridSetConfiguration.withDefaults((GridSet[])new GridSet[]{gridSet}));
        XMLConfiguration xmlConfig = this.loadXMLConfig();
        xmlConfig.setGridSetBroker(gridSetBroker);
        xmlConfig.afterPropertiesSet();
        LinkedList<XMLConfiguration> configList = new LinkedList<XMLConfiguration>();
        configList.add(xmlConfig);
        this.tld = new TileLayerDispatcher(gridSetBroker, configList, null);
        this.fc = new FilterUpdateController();
        this.fc.setTileLayerDispatcher(this.tld);
        this.mockMvc = MockMvcBuilders.standaloneSetup((Object[])new Object[]{this.fc}).build();
    }

    private XMLConfiguration loadXMLConfig() {
        XMLConfiguration xmlConfig = null;
        try {
            xmlConfig = new XMLConfiguration(null, (ConfigurationResourceProvider)new MockConfigurationResourceProvider(() -> XMLConfiguration.class.getResourceAsStream("geowebcache_125.xml")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xmlConfig;
    }

    @Test
    public void testPost() throws Exception {
        String filterXml = "<wmsRasterFilterUpdate>\n    <gridSetId>EPSG:4326</gridSetId>\n    <zoomStart>0</zoomStart>\n    <zoomStop>6</zoomStop>\n</wmsRasterFilterUpdate>";
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/filter/testWMSRasterFilter/update/xml", (Object[])new Object[0]).contentType(MediaType.APPLICATION_ATOM_XML).contextPath("").content(filterXml)).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
    }
}

