/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.controller;

import javax.servlet.http.HttpServletRequest;
import org.geowebcache.rest.controller.SeedController;
import org.geowebcache.rest.service.FormService;
import org.geowebcache.rest.service.SeedService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@RunWith(value=SpringRunner.class)
@WebAppConfiguration
@ContextConfiguration(value={"file:../web/src/main/webapp/WEB-INF/geowebcache-rest-context.xml", "file:../web/src/main/webapp/WEB-INF/geowebcache-core-context.xml"})
public class SeedControllerTest {
    @Autowired
    private WebApplicationContext wac;
    @Mock
    @Autowired
    private SeedService seedService;
    @InjectMocks
    @Autowired
    SeedController controller;
    @Spy
    @Autowired
    FormService formService;
    private MockMvc mockMvc;

    @Before
    public void setUp() throws Exception {
        this.mockMvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.wac).build();
        MockitoAnnotations.openMocks((Object)this);
        ((FormService)Mockito.doCallRealMethod().when((Object)this.formService)).handleFormPost(ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
    }

    @Test
    public void testSeedGetContentType() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/seed/{layer}", (Object[])new Object[]{"xxxp4z85"}).accept(new MediaType[]{MediaType.TEXT_HTML})).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_PLAIN)).andExpect(MockMvcResultMatchers.status().is4xxClientError());
    }

    @Test
    public void testSeedPostContentType() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/seed/{layer}", (Object[])new Object[]{"xxxp4z85"}).contentType(MediaType.APPLICATION_FORM_URLENCODED).accept(new MediaType[]{MediaType.TEXT_HTML})).andExpect(MockMvcResultMatchers.content().contentType(MediaType.TEXT_PLAIN)).andExpect(MockMvcResultMatchers.status().is4xxClientError());
    }

    @Test
    public void testSeedLayerNameWithDots() throws Exception {
        String layerName = "test:mock.layer.name";
        this.testGet(layerName);
        this.testGetJson(layerName);
        this.testGetXml(layerName);
        this.testPost(layerName);
    }

    private void testPost(String layerName) throws Exception {
        ((FormService)Mockito.doReturn((Object)ResponseEntity.ok(null)).when((Object)this.formService)).handleFormPost(ArgumentMatchers.anyString(), ArgumentMatchers.anyMap());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/seed/{layer}", (Object[])new Object[]{layerName}).contentType(MediaType.APPLICATION_FORM_URLENCODED).accept(new MediaType[]{MediaType.TEXT_XML})).andExpect(MockMvcResultMatchers.status().isOk());
        ((FormService)Mockito.verify((Object)this.formService)).handleFormPost((String)ArgumentMatchers.eq((Object)layerName), ArgumentMatchers.anyMap());
    }

    private void testGet(String layerName) throws Exception {
        ((FormService)Mockito.doReturn((Object)ResponseEntity.ok(null)).when((Object)this.formService)).handleGet((HttpServletRequest)ArgumentMatchers.any(HttpServletRequest.class), ArgumentMatchers.anyString());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/seed/{layer}", (Object[])new Object[]{layerName}).contentType(MediaType.TEXT_PLAIN).accept(new MediaType[]{MediaType.TEXT_HTML})).andExpect(MockMvcResultMatchers.status().isOk());
        ((FormService)Mockito.verify((Object)this.formService)).handleGet((HttpServletRequest)ArgumentMatchers.any(HttpServletRequest.class), (String)ArgumentMatchers.eq((Object)layerName));
    }

    private void testGetJson(String layerName) throws Exception {
        ((FormService)Mockito.doReturn((Object)ResponseEntity.ok(null)).when((Object)this.formService)).handleGet((HttpServletRequest)ArgumentMatchers.any(HttpServletRequest.class), ArgumentMatchers.anyString());
        ((SeedService)Mockito.doReturn((Object)ResponseEntity.ok(null)).when((Object)this.seedService)).getRunningLayerTasksXml(ArgumentMatchers.endsWith((String)".json"));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/seed/{layer}.json", (Object[])new Object[]{layerName}).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON})).andExpect(MockMvcResultMatchers.status().isOk());
        ((SeedService)Mockito.verify((Object)this.controller.seedService)).getRunningLayerTasks((String)ArgumentMatchers.eq((Object)layerName));
    }

    private void testGetXml(String layerName) throws Exception {
        ((FormService)Mockito.doReturn((Object)ResponseEntity.ok(null)).when((Object)this.formService)).handleGet((HttpServletRequest)ArgumentMatchers.any(HttpServletRequest.class), ArgumentMatchers.anyString());
        ((SeedService)Mockito.doReturn((Object)ResponseEntity.ok(null)).when((Object)this.seedService)).getRunningLayerTasksXml(ArgumentMatchers.endsWith((String)".xml"));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/seed/{layer}.xml", (Object[])new Object[]{layerName}).contentType(MediaType.APPLICATION_XML).accept(new MediaType[]{MediaType.APPLICATION_XML})).andExpect(MockMvcResultMatchers.status().isOk());
        ((SeedService)Mockito.verify((Object)this.controller.seedService)).getRunningLayerTasks((String)ArgumentMatchers.eq((Object)layerName));
    }
}

