/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.controller;

import org.geowebcache.rest.controller.ByteStreamController;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"file*:/webapp/WEB-INF/web.xml", "file*:/webapp/WEB-INF/geowebcache-servlet.xml"})
public class ByteStreamControllerTest {
    private MockMvc mockMvc;
    ByteStreamController bsc;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.bsc = new ByteStreamController();
        this.mockMvc = MockMvcBuilders.standaloneSetup((Object[])new Object[]{this.bsc}).build();
    }

    @Test
    public void setByteStreamController() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/web/doesnt%20exist", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is4xxClientError());
    }

    @Test
    public void testResourceFoundPNG() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/web/test.png", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is2xxSuccessful()).andExpect(MockMvcResultMatchers.header().string("Content-Type", Matchers.startsWith((String)"image/png")));
    }

    @Test
    public void testResourceFoundCSS() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/web/test.css", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is2xxSuccessful()).andExpect(MockMvcResultMatchers.header().string("Content-Type", Matchers.startsWith((String)"text/css")));
    }

    @Test
    public void testResourceFoundJS() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/web/test.js", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is2xxSuccessful()).andExpect(MockMvcResultMatchers.header().string("Content-Type", Matchers.startsWith((String)"text/javascript")));
    }

    @Test
    public void testResourceFoundSubdir() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/web/subdir/foo.css", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
    }

    @Test
    public void testClass() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/web/ByteStreamerRestlet.class", (Object[])new Object[0]));
    }

    @Test
    public void testAbsolute() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/web/org/geowebcache/shouldnt/access/test.png", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is4xxClientError());
    }

    @Test
    public void testBackreference() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/web/../../shouldnt/access/test.png", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is4xxClientError());
    }

    @Test
    public void testBackreference2() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/web/foo/../../../shouldnt/access/test.png", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is4xxClientError());
    }
}

