/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.dbcp.BasicDataSource;
import org.geowebcache.diskquota.jdbc.JDBCQuotaStoreTest;
import org.geowebcache.diskquota.jdbc.OracleDialect;
import org.geowebcache.diskquota.jdbc.SQLDialect;
import org.junit.Assume;

public class OracleQuotaStoreTest
extends JDBCQuotaStoreTest {
    @Override
    protected SQLDialect getDialect() {
        return new OracleDialect();
    }

    @Override
    protected JDBCQuotaStoreTest.JDBCFixtureRule makeFixtureRule() {
        return new JDBCQuotaStoreTest.JDBCFixtureRule(this.getFixtureId()){

            @Override
            void checkAvailable() {
                try {
                    Class.forName("oracle.jdbc.driver.OracleDriver");
                }
                catch (Exception e) {
                    Assume.assumeFalse((String)"Oracle driver not available", (boolean)true);
                }
                super.checkAvailable();
            }

            @Override
            protected Properties createExampleFixture() {
                Properties p = new Properties();
                p.put("driver", "oracle.jdbc.driver.OracleDriver");
                p.put("url", "jdbc:oracle:thin:@localhost:1521:xe");
                p.put("username", "geoserver");
                p.put("password", "postgis");
                return p;
            }
        };
    }

    @Override
    protected BasicDataSource getDataSource() throws IOException, SQLException {
        BasicDataSource dataSource = super.getDataSource();
        try (Connection cx = dataSource.getConnection();
             Statement st = cx.createStatement();){
            try {
                st.execute("DROP TABLE TILEPAGE CASCADE CONSTRAINTS");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                st.execute("DROP TABLE TILESET CASCADE CONSTRAINTS");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dataSource;
    }

    @Override
    protected String getFixtureId() {
        return "oracle";
    }
}

