/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.jdbc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.diskquota.jdbc.FixtureUtilities;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;
import org.junit.rules.ExternalResource;

public class OnlineTestRule
extends ExternalResource {
    static final Logger LOG = Logging.getLogger((String)OnlineTestRule.class.getName());
    public static final String ONLINE_TEST_PROFILE = "onlineTestProfile";
    public static final String SKIP_ON_FAILURE_KEY = "skip.on.failure";
    public static final String SKIP_ON_FAILURE_DEFAULT = "true";
    protected static Map<String, Boolean> online = new HashMap<String, Boolean>();
    protected static Map<String, Boolean> found = new HashMap<String, Boolean>();
    protected Properties fixture;
    protected boolean skipOnFailure = true;
    protected final String fixtureId;

    void checkAvailable() {
        this.configureFixture();
        Assume.assumeThat((String)"No fixture available", (Object)this.fixture, (Matcher)Matchers.notNullValue());
        Boolean available = online.get(this.fixtureId);
        Assume.assumeThat((String)"Fixture offline", (Object)available, (Matcher)Matchers.anyOf((Matcher)Matchers.nullValue(), (Matcher)Matchers.equalTo((Object)true)));
        try {
            available = this.isOnline();
        }
        catch (Throwable t) {
            LOG.info("Skipping " + this.fixtureId + " tests, resources not available: " + t.getMessage());
            t.printStackTrace();
            available = Boolean.FALSE;
        }
        online.put(this.fixtureId, available);
    }

    private void configureFixture() {
        if (this.fixture == null) {
            if (this.fixtureId == null) {
                return;
            }
            try {
                File fixtureFile;
                Boolean exists;
                File base = FixtureUtilities.getFixtureDirectory();
                String profile = System.getProperty(ONLINE_TEST_PROFILE);
                if (profile != null && !"".equals(profile)) {
                    base = new File(base, profile);
                }
                if ((exists = found.get((fixtureFile = FixtureUtilities.getFixtureFile(base, this.fixtureId)).getCanonicalPath())) == null || exists.booleanValue()) {
                    if (fixtureFile.exists()) {
                        this.fixture = FixtureUtilities.loadProperties(fixtureFile);
                        found.put(fixtureFile.getCanonicalPath(), true);
                    } else {
                        File exFixtureFile;
                        Properties exampleFixture;
                        if (profile == null && (exampleFixture = this.createExampleFixture()) != null && !(exFixtureFile = new File(fixtureFile.getAbsolutePath() + ".example")).exists()) {
                            this.createExampleFixture(exFixtureFile, exampleFixture);
                        }
                        found.put(fixtureFile.getCanonicalPath(), false);
                    }
                }
                if (this.fixture == null) {
                    this.fixture = this.createOfflineFixture();
                }
                if (this.fixture == null && exists == null) {
                    FixtureUtilities.printSkipNotice(this.fixtureId, fixtureFile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void createExampleFixture(File exFixtureFile, Properties exampleFixture) {
        try {
            exFixtureFile.getParentFile().mkdirs();
            exFixtureFile.createNewFile();
            try (FileOutputStream fout = new FileOutputStream(exFixtureFile);){
                exampleFixture.store(fout, "This is an example fixture. Update the values and remove the .example suffix to enable the test");
                fout.flush();
            }
            LOG.info("Wrote example fixture file to " + String.valueOf(exFixtureFile));
        }
        catch (IOException ioe) {
            LOG.info("Unable to write out example fixture " + String.valueOf(exFixtureFile));
            ioe.printStackTrace();
        }
    }

    protected final void before() throws Exception {
        this.checkAvailable();
        this.setUpInternal();
        this.skipOnFailure = Boolean.parseBoolean(this.fixture.getProperty(SKIP_ON_FAILURE_KEY, SKIP_ON_FAILURE_DEFAULT));
        try {
            this.connect();
        }
        catch (Exception e) {
            if (this.skipOnFailure) {
                this.fixture = null;
                throw new AssumptionViolatedException("Failure during connection to fixture " + this.fixtureId, (Throwable)e);
            }
            throw e;
        }
    }

    protected void setUpInternal() throws Exception {
    }

    protected final void after() {
        try {
            this.tearDownInternal();
        }
        catch (Exception e) {
            throw new AssertionError("Exception during tear down of fixture " + this.fixtureId, e);
        }
        finally {
            block11: {
                if (this.fixture != null) {
                    try {
                        this.disconnect();
                    }
                    catch (Exception e) {
                        if (this.skipOnFailure) break block11;
                        throw new AssertionError("Exception during disconnect of fixture " + this.fixtureId, e);
                    }
                }
            }
        }
    }

    protected void tearDownInternal() throws Exception {
    }

    protected boolean isOnline() throws Exception {
        return true;
    }

    protected void connect() throws Exception {
    }

    protected void disconnect() throws Exception {
    }

    protected Properties createOfflineFixture() {
        return null;
    }

    protected Properties createExampleFixture() {
        return null;
    }

    public OnlineTestRule(String fixtureId) {
        this.fixtureId = fixtureId;
    }

    public Properties getFixture() {
        return this.fixture;
    }
}

