/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.jdbc;

import java.io.File;
import java.util.HashMap;
import org.easymock.EasyMock;
import org.geowebcache.GeoWebCacheEnvironment;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.diskquota.jdbc.JDBCConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class JDBCConfigurationTest {
    ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);

    @Before
    public void setUp() throws Exception {
        System.setProperty("TEST_JDBC_DRIVER", "org.postgresql.Driver");
        System.setProperty("TEST_JDBC_URL", "jdbc:postgresql:gttest");
        System.setProperty("TEST_JDBC_USER", "test");
        System.setProperty("TEST_JDBC_PASSWORD", "toast");
        System.setProperty("ALLOW_ENV_PARAMETRIZATION", "true");
        GeoWebCacheExtensions gse = new GeoWebCacheExtensions();
        GeoWebCacheEnvironment genv = new GeoWebCacheEnvironment();
        gse.setApplicationContext(this.appContext);
        EasyMock.expect((Object)this.appContext.getBeanNamesForType(GeoWebCacheEnvironment.class)).andReturn((Object)new String[]{"environment"});
        EasyMock.expect((Object)this.appContext.getBean("environment")).andReturn((Object)genv);
        HashMap<String, GeoWebCacheEnvironment> genvMap = new HashMap<String, GeoWebCacheEnvironment>();
        genvMap.put("environment", genv);
        EasyMock.expect((Object)this.appContext.getBeansOfType(GeoWebCacheEnvironment.class)).andReturn(genvMap).anyTimes();
        EasyMock.expect((Object)this.appContext.getBean("environment")).andReturn((Object)genv).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.appContext});
    }

    @After
    public void tearDown() throws Exception {
        System.setProperty("TEST_JDBC_DRIVER", "");
        System.setProperty("TEST_JDBC_URL", "");
        System.setProperty("TEST_JDBC_USER", "");
        System.setProperty("TEST_JDBC_PASSWORD", "");
        System.setProperty("ALLOW_ENV_PARAMETRIZATION", "");
    }

    @Test
    public void testRoundTripJNDI() throws Exception {
        JDBCConfiguration config = new JDBCConfiguration();
        config.setDialect("Oracle");
        config.setJNDISource("java:comp/env/jdbc/oralocal");
        File file = new File("./target/jndi-jdbc.xml");
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        JDBCConfiguration.store((JDBCConfiguration)config, (File)file);
        JDBCConfiguration config2 = JDBCConfiguration.load((File)file);
        Assert.assertEquals((Object)config2, (Object)config);
    }

    @Test
    public void testRoundTripConnectionPool() throws Exception {
        JDBCConfiguration config = new JDBCConfiguration();
        config.setDialect("PostgreSQL");
        JDBCConfiguration.ConnectionPoolConfiguration cp = new JDBCConfiguration.ConnectionPoolConfiguration();
        cp.setDriver("org.postgresql.Driver");
        cp.setUrl("jdbc:postgresql:gttest");
        cp.setUsername("test");
        cp.setPassword("toast");
        cp.setMinConnections(1);
        cp.setMaxConnections(10);
        cp.setValidationQuery("select 1");
        cp.setMaxOpenPreparedStatements(50);
        config.setConnectionPool(cp);
        File file = new File("./target/dbcp-jdbc.xml");
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        JDBCConfiguration.store((JDBCConfiguration)config, (File)file);
        JDBCConfiguration config2 = JDBCConfiguration.load((File)file);
        Assert.assertEquals((Object)config2, (Object)config);
    }

    @Test
    public void testRoundTripParametrizedConnectionPool() throws Exception {
        File file2;
        JDBCConfiguration config = new JDBCConfiguration();
        config.setDialect("PostgreSQL");
        JDBCConfiguration.ConnectionPoolConfiguration cp = new JDBCConfiguration.ConnectionPoolConfiguration();
        cp.setDriver("${TEST_JDBC_DRIVER}");
        cp.setUrl("${TEST_JDBC_URL}");
        cp.setUsername("${TEST_JDBC_USER}");
        cp.setPassword("${TEST_JDBC_PASSWORD}");
        cp.setMinConnections(1);
        cp.setMaxConnections(10);
        cp.setValidationQuery("select 1");
        cp.setMaxOpenPreparedStatements(50);
        config.setConnectionPool(cp);
        File file1 = new File("./target/dbcp-jdbc1.xml");
        if (file1.exists()) {
            Assert.assertTrue((boolean)file1.delete());
        }
        if ((file2 = new File("./target/dbcp-jdbc2.xml")).exists()) {
            Assert.assertTrue((boolean)file2.delete());
        }
        JDBCConfiguration.store((JDBCConfiguration)config.clone(true), (File)file1);
        JDBCConfiguration config1 = JDBCConfiguration.load((File)file1);
        Assert.assertNotSame((Object)config1, (Object)config);
        JDBCConfiguration.store((JDBCConfiguration)config.clone(false), (File)file2);
        JDBCConfiguration config2 = JDBCConfiguration.load((File)file2);
        Assert.assertEquals((Object)config2, (Object)config);
    }
}

