/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.io.IOException;
import java.util.List;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.diskquota.ConfigLoader;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.QuotaStoreFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class QuotaStoreProvider
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    protected QuotaStore store;
    protected ApplicationContext applicationContext;
    protected ConfigLoader loader;

    public QuotaStoreProvider(ConfigLoader loader) {
        this.loader = loader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public synchronized QuotaStore getQuotaStore() throws ConfigurationException, IOException {
        return this.store;
    }

    public void destroy() throws Exception {
        this.store.close();
    }

    public void afterPropertiesSet() throws Exception {
        this.replaceH2WithHsql();
        this.reloadQuotaStore();
    }

    private void replaceH2WithHsql() throws IOException, ConfigurationException {
        DiskQuotaConfig config = this.loader.loadConfig();
        if (config.getQuotaStore() != null && config.getQuotaStore().equals("H2")) {
            config.setQuotaStore("HSQL");
            this.loader.saveConfig(config);
        }
    }

    public void reloadQuotaStore() throws IOException, ConfigurationException {
        DiskQuotaConfig config = this.loader.loadConfig();
        String quotaStoreName = config.getQuotaStore();
        if (quotaStoreName == null) {
            quotaStoreName = "BDB";
        }
        this.store = this.getQuotaStoreByName(quotaStoreName);
    }

    protected QuotaStore getQuotaStoreByName(String quotaStoreName) throws ConfigurationException, IOException {
        List factories = GeoWebCacheExtensions.extensions(QuotaStoreFactory.class, (ApplicationContext)this.applicationContext);
        for (QuotaStoreFactory factory : factories) {
            QuotaStore store = factory.getQuotaStore(this.applicationContext, quotaStoreName);
            if (store == null) continue;
            return store;
        }
        throw new IllegalStateException("Could not find a quota store named " + quotaStoreName);
    }
}

