/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public abstract class AbstractMonitor {
    private static final Logger log = Logging.getLogger((String)AbstractMonitor.class.getName());
    private ExecutorService executorService;

    public void startUp() {
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)this.getThreadFactory());
    }

    protected abstract CustomizableThreadFactory getThreadFactory();

    protected ExecutorService getExecutorService() {
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void shutDown() {
        boolean cancel = false;
        this.shutDown(false);
        int maxAttempts = 6;
        int seconds = 5;
        int attempts = 1;
        boolean interrupted = false;
        try {
            while (!this.getExecutorService().isTerminated()) {
                ++attempts;
                try {
                    this.awaitTermination(5, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    String message = "Usage statistics thread helper for DiskQuota failed to shutdown within " + attempts * 5 + " seconds. Attempt " + attempts + " of 6...";
                    log.warning(message);
                    if (attempts != 6) continue;
                    throw new RuntimeException(message, e);
                    return;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void awaitTermination(int timeout, TimeUnit units) throws InterruptedException {
        if (!this.getExecutorService().isShutdown()) {
            throw new IllegalStateException("Called awaitTermination but the UsageStatsMonitor is not shutting down");
        }
        this.getExecutorService().awaitTermination(timeout, units);
    }

    protected abstract void shutDown(boolean var1);

    public void shutDownNow() {
        this.shutDown(true);
    }
}

