/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.storage;

import java.math.BigInteger;
import org.geowebcache.diskquota.storage.MockSystemUtils;
import org.geowebcache.diskquota.storage.PageStats;
import org.geowebcache.diskquota.storage.SystemUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PageStatsTest {
    private static final int CREATION_TIME_MINUTES = 1000;
    private MockSystemUtils mockSysUtils;

    @Before
    public void setUp() {
        this.mockSysUtils = new MockSystemUtils();
        this.mockSysUtils.setCurrentTimeMinutes(1000);
        this.mockSysUtils.setCurrentTimeMillis(60000000L);
        SystemUtils.set((SystemUtils)this.mockSysUtils);
    }

    @Test
    public void testAddHitsNoFillFactor() {
        PageStats stats = new PageStats(1L);
        stats.setFillFactor(0.0f);
        stats.addHitsAndAccessTime(10L, 1000, 1000);
        float frequencyOfUsePerMinute = stats.getFrequencyOfUsePerMinute();
        Assert.assertEquals((float)Float.MIN_VALUE, (float)frequencyOfUsePerMinute, (float)1.0E-6f);
    }

    @Test
    public void testAddHitsNoFillFactorNewLastAccessTime() {
        PageStats stats = new PageStats(1L);
        stats.setFillFactor(0.0f);
        stats.addHitsAndAccessTime(10L, 1002, 1000);
        float frequencyOfUsePerMinute = stats.getFrequencyOfUsePerMinute();
        Assert.assertEquals((float)Float.MIN_VALUE, (float)frequencyOfUsePerMinute, (float)1.0E-6f);
    }

    @Test
    public void testAddHitsFullFillFactor() {
        PageStats stats = new PageStats(1L);
        stats.setFillFactor(1.0f);
        int numHits = 10;
        stats.addHitsAndAccessTime(10L, 1000, 1000);
        float frequencyOfUsePerMinute = stats.getFrequencyOfUsePerMinute();
        Assert.assertEquals((float)10.0f, (float)frequencyOfUsePerMinute, (float)1.0E-6f);
    }

    @Test
    public void testAddHitsFullFillFactorNewLastAccessTime() {
        PageStats stats = new PageStats(1L);
        stats.setFillFactor(1.0f);
        int numHits = 10;
        stats.addHitsAndAccessTime((long)numHits, 1002, 1000);
        float frequencyOfUsePerMinute = stats.getFrequencyOfUsePerMinute();
        Assert.assertEquals((float)((float)numHits / 3.0f), (float)frequencyOfUsePerMinute, (float)1.0E-6f);
        numHits = 100;
        stats.addHitsAndAccessTime((long)numHits, 1003, 1000);
        frequencyOfUsePerMinute = stats.getFrequencyOfUsePerMinute();
        Assert.assertEquals((float)27.5f, (float)frequencyOfUsePerMinute, (float)1.0E-6f);
    }

    @Test
    public void testAddHitsHalfFillFactor() {
        PageStats stats = new PageStats(1L);
        stats.setFillFactor(0.5f);
        int numHits = 10;
        stats.addHitsAndAccessTime(10L, 1000, 1000);
        float frequencyOfUsePerMinute = stats.getFrequencyOfUsePerMinute();
        Assert.assertEquals((float)5.0f, (float)frequencyOfUsePerMinute, (float)1.0E-6f);
    }

    @Test
    public void testAddHitsHalfFillFactorNewLastAccessTime() {
        PageStats stats = new PageStats(1L);
        float fillFactor = 0.5f;
        stats.setFillFactor(fillFactor);
        int numHits = 10;
        stats.addHitsAndAccessTime((long)numHits, 1002, 1000);
        float frequencyOfUsePerMinute = stats.getFrequencyOfUsePerMinute();
        Assert.assertEquals((float)(fillFactor * ((float)numHits / 3.0f)), (float)frequencyOfUsePerMinute, (float)1.0E-6f);
    }

    @Test
    public void testAddTiles() {
        PageStats stats = new PageStats(1L);
        BigInteger maxTiles = BigInteger.valueOf(1000L);
        stats.addTiles(1L, maxTiles);
        Assert.assertEquals((float)0.001f, (float)stats.getFillFactor(), (float)1.0E-6f);
        stats.addTiles(499L, maxTiles);
        Assert.assertEquals((float)0.5f, (float)stats.getFillFactor(), (float)1.0E-6f);
        stats.addTiles(500L, maxTiles);
        Assert.assertEquals((float)1.0f, (float)stats.getFillFactor(), (float)1.0E-6f);
    }
}

