/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.storage;

import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.diskquota.storage.PagePyramid;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.storage.blobstore.file.FilePathUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PagePyramidTest {
    static final Logger LOG = Logging.getLogger((String)PagePyramidTest.class.getName());
    GridSet world_EPSG3857 = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, false))).getWorldEpsg3857();
    GridSet world_EPSG4326 = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, false))).getWorldEpsg4326();
    private long[][] coverages;
    private PagePyramid pyramid;

    @Before
    public void setUp() {
        this.coverages = new long[][]{{0L, 0L, 1L, 1L, 0L}, {3L, 3L, 10L, 10L, 1L}, {0L, 0L, 101L, 101L, 2L}, {1000L, 1000L, 3000L, 3000L, 3L}};
        this.pyramid = new PagePyramid(this.coverages, 0, 3);
    }

    @Test
    public void testCalculatePageInfo() {
        GridSubset gridSubSet = GridSubsetFactory.createGridSubSet((GridSet)this.world_EPSG3857);
        long[][] gridSubsetCoverages = gridSubSet.getCoverages();
        int zoomStart = gridSubSet.getZoomStart();
        int zoomStop = gridSubSet.getZoomStop();
        PagePyramid pp = new PagePyramid(gridSubsetCoverages, zoomStart, zoomStop);
        this.printPyramid(zoomStart, zoomStop, pp);
    }

    private void printPyramid(int zoomStart, int zoomStop, PagePyramid pp) {
        NumberFormat nf = NumberFormat.getInstance(new Locale("es"));
        nf.setGroupingUsed(true);
        long totalPages = 0L;
        BigInteger totalTiles = BigInteger.ZERO;
        for (int z = zoomStart; z <= zoomStop; ++z) {
            PagePyramid.PageLevelInfo pageInfo = pp.getPageInfo(z);
            long levelPages = pageInfo.pagesX * pageInfo.pagesY;
            BigInteger tilesPerPage = pageInfo.tilesPerPage;
            totalTiles = totalTiles.add(tilesPerPage.multiply(BigInteger.valueOf(levelPages)));
            LOG.info(FilePathUtils.zeroPadder((long)z, (int)2) + ": (total pages =" + nf.format(totalPages += levelPages) + ") " + pageInfo.toString() + "(level tiles = " + nf.format(tilesPerPage.multiply(BigInteger.valueOf(levelPages))) + ") ");
        }
        LOG.info("Total pages: " + totalPages);
    }

    @Test
    public void testGetPagesPerLevel() {
        Assert.assertEquals((long)2L, (long)this.pyramid.getPagesPerLevelX(0));
        Assert.assertEquals((long)2L, (long)this.pyramid.getPagesPerLevelY(0));
        Assert.assertEquals((long)8L, (long)this.pyramid.getPagesPerLevelX(1));
        Assert.assertEquals((long)8L, (long)this.pyramid.getPagesPerLevelY(1));
        Assert.assertEquals((long)34L, (long)this.pyramid.getPagesPerLevelX(2));
        Assert.assertEquals((long)34L, (long)this.pyramid.getPagesPerLevelY(2));
        Assert.assertEquals((long)77L, (long)this.pyramid.getPagesPerLevelX(3));
        Assert.assertEquals((long)77L, (long)this.pyramid.getPagesPerLevelY(3));
    }

    @Test
    public void testGetTilesPerPage() {
        Assert.assertEquals((long)1L, (long)this.pyramid.getTilesPerPageX(0));
        Assert.assertEquals((long)1L, (long)this.pyramid.getTilesPerPageY(0));
        Assert.assertEquals((long)1L, (long)this.pyramid.getTilesPerPageX(1));
        Assert.assertEquals((long)1L, (long)this.pyramid.getTilesPerPageY(1));
        Assert.assertEquals((long)3L, (long)this.pyramid.getTilesPerPageX(2));
        Assert.assertEquals((long)3L, (long)this.pyramid.getTilesPerPageY(2));
        Assert.assertEquals((long)26L, (long)this.pyramid.getTilesPerPageX(3));
        Assert.assertEquals((long)26L, (long)this.pyramid.getTilesPerPageY(3));
    }

    @Test
    public void testToGridCoverage() {
        long[][] gridCoverage = this.pyramid.toGridCoverage(0, 0, 0);
        Assert.assertEquals(this.asList(0L, 0L, 0L, 0L, 0L), this.asList(gridCoverage[0]));
        int level = 1;
        int pageX = 2;
        int pageY = 2;
        int pageZ = 1;
        gridCoverage = this.pyramid.toGridCoverage(pageX, pageY, pageZ);
        int tilesPerPageX = this.pyramid.getTilesPerPageX(level);
        int tilesPerPageY = this.pyramid.getTilesPerPageY(level);
        long[] expected = new long[]{this.coverages[level][0] + (long)(tilesPerPageX * pageX), this.coverages[level][1] + (long)(tilesPerPageY * pageY), this.coverages[level][0] + (long)(tilesPerPageX * pageX) + (long)tilesPerPageX - 1L, this.coverages[level][0] + (long)(tilesPerPageY * pageY) + (long)tilesPerPageY - 1L, pageZ};
        Assert.assertEquals(this.asList(expected), this.asList(gridCoverage[1]));
    }

    @Test
    public void testPageIndexForTile() throws Exception {
        try {
            this.pyramid.pageIndexForTile(0L, 0L, 0, null);
            Assert.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            this.pyramid.pageIndexForTile(0L, 0L, 0, new int[2]);
            Assert.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        this.printPyramid(this.pyramid.getZoomStart(), this.pyramid.getZoomStop(), this.pyramid);
        int[] pageIndexTarget = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        int[] expected = new int[]{0, 0, 0};
        this.pyramid.pageIndexForTile(0L, 0L, 0, pageIndexTarget);
        Assert.assertArrayEquals((String)Arrays.toString(pageIndexTarget), (int[])expected, (int[])pageIndexTarget);
        expected = new int[]{1, 1, 0};
        this.pyramid.pageIndexForTile(1L, 1L, 0, pageIndexTarget);
        Assert.assertArrayEquals((String)Arrays.toString(pageIndexTarget), (int[])expected, (int[])pageIndexTarget);
        expected = new int[]{0, 0, 1};
        this.pyramid.pageIndexForTile(3L, 3L, 1, pageIndexTarget);
        Assert.assertArrayEquals((String)Arrays.toString(pageIndexTarget), (int[])expected, (int[])pageIndexTarget);
        expected = new int[]{1, 1, 1};
        this.pyramid.pageIndexForTile(4L, 4L, 1, pageIndexTarget);
        Assert.assertArrayEquals((String)Arrays.toString(pageIndexTarget), (int[])expected, (int[])pageIndexTarget);
        expected = new int[]{7, 7, 1};
        this.pyramid.pageIndexForTile(10L, 10L, 1, pageIndexTarget);
        Assert.assertArrayEquals((String)Arrays.toString(pageIndexTarget), (int[])expected, (int[])pageIndexTarget);
        expected = new int[]{0, 0, 3};
        this.pyramid.pageIndexForTile(1000L, 1000L, 3, pageIndexTarget);
        Assert.assertArrayEquals((String)Arrays.toString(pageIndexTarget), (int[])expected, (int[])pageIndexTarget);
        expected = new int[]{1, 1, 3};
        this.pyramid.pageIndexForTile(1026L, 1026L, 3, pageIndexTarget);
        Assert.assertArrayEquals((String)Arrays.toString(pageIndexTarget), (int[])expected, (int[])pageIndexTarget);
    }

    private List<Long> asList(long ... coverage) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (long l : coverage) {
            list.add(l);
        }
        return list;
    }
}

