/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.math.BigDecimal;
import org.geowebcache.diskquota.storage.StorageUnit;
import org.junit.Assert;
import org.junit.Test;

public class StorageUnitTest {
    @Test
    public void testConvertTo() {
        Assert.assertEquals((double)1.0, (double)StorageUnit.B.convertTo(1024.0, StorageUnit.KiB).doubleValue(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)StorageUnit.KiB.convertTo(1048576.0, StorageUnit.GiB).doubleValue(), (double)0.0);
        Assert.assertEquals((double)1024.0, (double)StorageUnit.GiB.convertTo(1048576.0, StorageUnit.TiB).doubleValue(), (double)0.0);
        BigDecimal k = BigDecimal.valueOf(1024L);
        BigDecimal value = k.multiply(k).multiply(k).multiply(k).multiply(k);
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)StorageUnit.B.convertTo(value, StorageUnit.PiB));
    }

    @Test
    public void testClosest() {
        Assert.assertEquals((Object)StorageUnit.YiB, (Object)StorageUnit.bestFit((double)1.0, (StorageUnit)StorageUnit.YiB));
        Assert.assertEquals((Object)StorageUnit.YiB, (Object)StorageUnit.bestFit((double)1025.0, (StorageUnit)StorageUnit.ZiB));
        Assert.assertEquals((Object)StorageUnit.ZiB, (Object)StorageUnit.bestFit((double)1023.0, (StorageUnit)StorageUnit.ZiB));
        Assert.assertEquals((Object)StorageUnit.ZiB, (Object)StorageUnit.bestFit((double)1025.0, (StorageUnit)StorageUnit.EiB));
        Assert.assertEquals((Object)StorageUnit.EiB, (Object)StorageUnit.bestFit((double)1023.0, (StorageUnit)StorageUnit.EiB));
        Assert.assertEquals((Object)StorageUnit.EiB, (Object)StorageUnit.bestFit((double)1025.0, (StorageUnit)StorageUnit.PiB));
        Assert.assertEquals((Object)StorageUnit.PiB, (Object)StorageUnit.bestFit((double)1023.0, (StorageUnit)StorageUnit.PiB));
        Assert.assertEquals((Object)StorageUnit.TiB, (Object)StorageUnit.bestFit((double)1023.0, (StorageUnit)StorageUnit.TiB));
        Assert.assertEquals((Object)StorageUnit.TiB, (Object)StorageUnit.bestFit((double)1025.0, (StorageUnit)StorageUnit.GiB));
        Assert.assertEquals((Object)StorageUnit.GiB, (Object)StorageUnit.bestFit((double)1023.0, (StorageUnit)StorageUnit.GiB));
        Assert.assertEquals((Object)StorageUnit.GiB, (Object)StorageUnit.bestFit((double)1025.0, (StorageUnit)StorageUnit.MiB));
        Assert.assertEquals((Object)StorageUnit.MiB, (Object)StorageUnit.bestFit((double)1023.0, (StorageUnit)StorageUnit.MiB));
        Assert.assertEquals((Object)StorageUnit.MiB, (Object)StorageUnit.bestFit((double)1025.0, (StorageUnit)StorageUnit.KiB));
        Assert.assertEquals((Object)StorageUnit.KiB, (Object)StorageUnit.bestFit((double)1023.0, (StorageUnit)StorageUnit.KiB));
        Assert.assertEquals((Object)StorageUnit.KiB, (Object)StorageUnit.bestFit((double)1025.0, (StorageUnit)StorageUnit.B));
        Assert.assertEquals((Object)StorageUnit.B, (Object)StorageUnit.bestFit((double)0.5, (StorageUnit)StorageUnit.KiB));
    }
}

