/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import org.easymock.EasyMock;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.diskquota.ConfigLoader;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.ExpirationPolicy;
import org.geowebcache.diskquota.storage.LayerQuota;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.StorageUnit;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.util.ApplicationContextProvider;
import org.geowebcache.util.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class ConfigLoaderTest {
    private File cacheDir;
    DefaultStorageFinder storageFinder;
    ApplicationContextProvider contextProvider;
    TileLayerDispatcher tld;
    private ConfigLoader loader;

    @Before
    public void setUp() throws Exception {
        this.cacheDir = new File("target" + File.separator + this.getClass().getSimpleName());
        if (!this.cacheDir.getParentFile().exists()) {
            throw new IllegalStateException(this.cacheDir.getParentFile().getAbsolutePath() + " does not exist");
        }
        FileUtils.rmFileCacheDir((File)this.cacheDir, null);
        this.cacheDir.mkdirs();
        try (InputStream in = this.getClass().getResourceAsStream("/geowebcache-diskquota.xml");
             FileOutputStream out = new FileOutputStream(new File(this.cacheDir, "geowebcache-diskquota.xml"));){
            int c;
            while ((c = in.read()) != -1) {
                out.write(c);
            }
        }
        this.storageFinder = (DefaultStorageFinder)EasyMock.createMock(DefaultStorageFinder.class);
        EasyMock.expect((Object)this.storageFinder.getDefaultPath()).andReturn((Object)this.cacheDir.getAbsolutePath()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.storageFinder});
        ServletContext mockServletCtx = (ServletContext)EasyMock.createMock(ServletContext.class);
        String tmpPath = System.getProperty("java.io.tmpdir");
        EasyMock.expect((Object)mockServletCtx.getRealPath((String)EasyMock.eq((Object)""))).andReturn((Object)tmpPath).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockServletCtx});
        WebApplicationContext appContext = (WebApplicationContext)EasyMock.createMock(WebApplicationContext.class);
        EasyMock.expect((Object)appContext.getServletContext()).andReturn((Object)mockServletCtx).anyTimes();
        EasyMock.replay((Object[])new Object[]{appContext});
        this.contextProvider = new ApplicationContextProvider();
        this.contextProvider.setApplicationContext((ApplicationContext)appContext);
        this.tld = (TileLayerDispatcher)EasyMock.createMock(TileLayerDispatcher.class);
        TileLayer toppStates = this.createMockLayer("topp:states");
        TileLayer raster = this.createMockLayer("raster test layer");
        EasyMock.expect((Object)this.tld.getTileLayer((String)EasyMock.eq((Object)"topp:states"))).andReturn((Object)toppStates).anyTimes();
        EasyMock.expect((Object)this.tld.getTileLayer((String)EasyMock.eq((Object)"raster test layer"))).andReturn((Object)raster).anyTimes();
        ArrayList<TileLayer> tileLayers = new ArrayList<TileLayer>();
        tileLayers.add(toppStates);
        tileLayers.add(raster);
        EasyMock.expect((Object)this.tld.getLayerList()).andReturn(tileLayers).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.tld});
        this.loader = new ConfigLoader(this.storageFinder, this.contextProvider, this.tld);
    }

    @After
    public void tearDown() throws Exception {
        if (this.cacheDir != null) {
            FileUtils.rmFileCacheDir((File)this.cacheDir, null);
        }
    }

    private TileLayer createMockLayer(String name) {
        TileLayer layer = (TileLayer)EasyMock.createMock(TileLayer.class);
        EasyMock.expect((Object)layer.getName()).andReturn((Object)name).anyTimes();
        EasyMock.replay((Object[])new Object[]{layer});
        return layer;
    }

    @Test
    public void testLoadConfig() throws ConfigurationException, IOException {
        DiskQuotaConfig config = this.loader.loadConfig();
        Assert.assertNotNull((Object)config);
        Assert.assertFalse((boolean)config.isEnabled());
        Assert.assertEquals((long)10L, (long)config.getCacheCleanUpFrequency().intValue());
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)config.getCacheCleanUpUnits()));
        Assert.assertEquals((long)3L, (long)config.getMaxConcurrentCleanUps().intValue());
        Assert.assertEquals((Object)ExpirationPolicy.LFU, (Object)config.getGlobalExpirationPolicyName());
        Assert.assertNotNull((Object)config.getGlobalExpirationPolicyName());
        Assert.assertNotNull((Object)config.getGlobalQuota());
        Assert.assertEquals((long)StorageUnit.GiB.convertTo(200.0, StorageUnit.B).longValue(), (long)config.getGlobalQuota().getBytes().longValue());
        Assert.assertNotNull((Object)config.getLayerQuotas());
        Assert.assertEquals((long)2L, (long)config.getLayerQuotas().size());
        LayerQuota states = config.layerQuota("topp:states");
        Assert.assertNotNull((Object)states);
        Assert.assertEquals((Object)ExpirationPolicy.LFU, (Object)states.getExpirationPolicyName());
        Assert.assertEquals((long)StorageUnit.MiB.convertTo(100.0, StorageUnit.B).longValue(), (long)states.getQuota().getBytes().longValue());
        LayerQuota raster = config.layerQuota("raster test layer");
        Assert.assertNotNull((Object)raster);
    }

    @Test
    public void testSaveConfig() throws ConfigurationException, IOException {
        DiskQuotaConfig config = new DiskQuotaConfig();
        ArrayList<LayerQuota> quotas = new ArrayList<LayerQuota>();
        LayerQuota lq = new LayerQuota("topp:states", ExpirationPolicy.LRU, new Quota(10.0, StorageUnit.MiB));
        quotas.add(lq);
        config.addLayerQuota(lq);
        File configFile = new File(this.cacheDir, "geowebcache-diskquota.xml");
        if (configFile.exists()) {
            configFile.delete();
        }
        this.loader.saveConfig(config);
        Assert.assertTrue((boolean)configFile.exists());
    }

    @Test
    public void testGetRootCacheDir() throws Exception {
        Assert.assertEquals((Object)this.cacheDir.getAbsolutePath(), (Object)this.loader.getRootCacheDir().getAbsolutePath());
    }
}

