/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.bdb;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.model.EntityModel;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.diskquota.bdb.DiskQuotaEntityModel;
import org.geowebcache.diskquota.storage.PageStoreConfig;

public class EntityStoreBuilder {
    private static final Logger log = Logging.getLogger((String)EntityStoreBuilder.class.getName());
    private PageStoreConfig config;

    public EntityStoreBuilder(PageStoreConfig config) {
        this.config = config;
    }

    public EntityStore buildEntityStore(File storeDirectory, Properties bdbEnvProperties) {
        EnvironmentConfig envCfg = new EnvironmentConfig();
        envCfg.setAllowCreate(true);
        envCfg.setCacheMode(CacheMode.DEFAULT);
        envCfg.setLockTimeout(1000L, TimeUnit.MILLISECONDS);
        envCfg.setDurability(Durability.COMMIT_WRITE_NO_SYNC);
        envCfg.setSharedCache(true);
        envCfg.setTransactional(true);
        envCfg.setConfigParam("je.log.fileMax", String.valueOf(0x6400000));
        Integer cacheMemoryPercentAllowed = this.config.getCacheMemoryPercentAllowed();
        Integer cacheSizeMB = this.config.getCacheSizeMB();
        if (cacheMemoryPercentAllowed == null) {
            if (cacheSizeMB == null) {
                log.config("Neither disk quota page store' cache memory percent nor cache size was provided. Defaulting to 25% Heap Size");
                envCfg.setCachePercent(25);
            } else {
                log.config("Disk quota page store cache explicitly set to " + cacheSizeMB + "MB");
                envCfg.setCacheSize((long)cacheSizeMB.intValue());
            }
        } else {
            envCfg.setCachePercent(cacheMemoryPercentAllowed.intValue());
        }
        Environment env = new Environment(storeDirectory, envCfg);
        String storeName = "GWC DiskQuota page store";
        StoreConfig config = new StoreConfig();
        config.setAllowCreate(true);
        config.setTransactional(true);
        config.setModel((EntityModel)new DiskQuotaEntityModel());
        EntityStore entityStore = new EntityStore(env, storeName, config);
        return entityStore;
    }
}

