/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.bdb;

import com.sleepycat.persist.model.AnnotationModel;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.DeleteAction;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.Relationship;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.geowebcache.diskquota.bdb.ClassMetadataBuilder;
import org.geowebcache.diskquota.storage.PageStats;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.TilePage;
import org.geowebcache.diskquota.storage.TileSet;

public class DiskQuotaEntityModel
extends AnnotationModel {
    private Map<String, ClassMetadata> classes = new HashMap<String, ClassMetadata>();
    private Map<String, EntityMetadata> entities = new HashMap<String, EntityMetadata>();

    public DiskQuotaEntityModel() {
        try {
            ClassMetadataBuilder builder = new ClassMetadataBuilder();
            builder.entity(Quota.class);
            builder.primaryKey("id", "quota_id");
            builder.secondaryKey("tileSetId", "tileset_id", Relationship.ONE_TO_ONE, TileSet.class, DeleteAction.CASCADE);
            this.registerClassMetadata(builder.build());
            builder.entity(PageStats.class);
            builder.primaryKey("id", "page_stats_seq");
            builder.secondaryKey("pageId", "page_stats_by_page_id", Relationship.ONE_TO_ONE, TilePage.class, DeleteAction.CASCADE);
            builder.secondaryKey("frequencyOfUse", "LFU", Relationship.MANY_TO_ONE, null, DeleteAction.ABORT);
            builder.secondaryKey("lastAccessTimeMinutes", "LRU", Relationship.MANY_TO_ONE, null, DeleteAction.ABORT);
            builder.secondaryKey("fillFactor", "fill_factory", Relationship.MANY_TO_ONE, null, DeleteAction.ABORT);
            this.registerClassMetadata(builder.build());
            builder.entity(TilePage.class);
            builder.primaryKey("id", "page_id");
            builder.secondaryKey("tileSetId", "tileset_id_fk", Relationship.MANY_TO_ONE, TileSet.class, DeleteAction.CASCADE);
            builder.secondaryKey("key", "page_key", Relationship.ONE_TO_ONE, null, DeleteAction.ABORT);
            this.registerClassMetadata(builder.build());
            builder.entity(TileSet.class);
            builder.primaryKey("key", null);
            builder.secondaryKey("layerName", "layer", Relationship.MANY_TO_ONE, null, DeleteAction.ABORT);
            this.registerClassMetadata(builder.build());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unexpected setup exception occurred: " + e.getMessage(), e);
        }
    }

    private void registerClassMetadata(ClassMetadata classMetadata) {
        this.classes.put(classMetadata.getClassName(), classMetadata);
        EntityMetadata entityMetadata = new EntityMetadata(classMetadata.getClassName(), classMetadata.getPrimaryKey(), classMetadata.getSecondaryKeys());
        this.entities.put(classMetadata.getClassName(), entityMetadata);
    }

    public ClassMetadata getClassMetadata(String className) {
        ClassMetadata metadata = super.getClassMetadata(className);
        if (metadata != null) {
            return metadata;
        }
        return this.classes.get(className);
    }

    public EntityMetadata getEntityMetadata(String className) {
        EntityMetadata metadata = super.getEntityMetadata(className);
        if (metadata != null) {
            return metadata;
        }
        return this.entities.get(className);
    }

    public Set<String> getKnownClasses() {
        return this.classes.keySet();
    }
}

