/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.bdb;

import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.DeleteAction;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.model.FieldMetadata;
import com.sleepycat.persist.model.PrimaryKeyMetadata;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKeyMetadata;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ClassMetadataBuilder {
    private Class entityClass;
    private PrimaryKeyMetadata primaryKey;
    private List<SecondaryKeyMetadata> secondaryKeys = new ArrayList<SecondaryKeyMetadata>();

    public void entity(Class type) {
        this.entityClass = type;
    }

    public void primaryKey(String field, String sequence) {
        Field pkField = this.getField(field);
        this.primaryKey = new PrimaryKeyMetadata(pkField.getName(), pkField.getType().getName(), this.entityClass.getName(), sequence);
    }

    public void secondaryKey(String field, String keyName, Relationship relationship, Class relatedEntity, DeleteAction deleteAction) {
        Field skField = this.getField(field);
        this.secondaryKeys.add(new SecondaryKeyMetadata(skField.getName(), this.entityClass.getName(), this.entityClass.getName(), skField.getType().getName(), keyName, relationship, relatedEntity != null ? relatedEntity.getName() : null, deleteAction));
    }

    private Field getField(String lookup) {
        for (Field field : this.entityClass.getDeclaredFields()) {
            if (!field.getName().equals(lookup)) continue;
            return field;
        }
        throw new IllegalArgumentException("Field " + lookup + " not found in " + String.valueOf(this.entityClass));
    }

    public ClassMetadata build() throws ClassNotFoundException {
        Class type = EntityModel.classForName((String)this.entityClass.getName());
        if (type.isEnum() || type.isInterface() || type.isPrimitive()) {
            throw new IllegalArgumentException("Enumerations, interfaces or primitive types cannot be entities: " + type.getName());
        }
        ArrayList<FieldMetadata> fields = new ArrayList<FieldMetadata>();
        for (Field field : type.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
            fields.add(new FieldMetadata(field.getName(), field.getType().getName(), type.getName()));
        }
        HashMap<String, SecondaryKeyMetadata> secondaryKeyMap = new HashMap<String, SecondaryKeyMetadata>();
        if (this.secondaryKeys != null) {
            for (SecondaryKeyMetadata metadata : this.secondaryKeys) {
                secondaryKeyMap.put(metadata.getName(), metadata);
            }
            this.secondaryKeys.clear();
        }
        ClassMetadata classMetadata = new ClassMetadata(type.getName(), 0, null, true, this.primaryKey, secondaryKeyMap, null, fields);
        this.primaryKey = null;
        this.entityClass = null;
        return classMetadata;
    }
}

