/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

public class FileUtils {
    private static final File[] NO_FILES = new File[0];
    static Logger log = Logging.getLogger((String)FileUtils.class.toString());

    public static boolean rmFileCacheDir(File path, ExtensionFileLister extfl) {
        if (path.exists()) {
            File[] files = null;
            files = extfl != null ? FileUtils.listFilesNullSafe(path, extfl) : FileUtils.listFilesNullSafe(path);
            for (File file : files) {
                if (file.isDirectory()) {
                    FileUtils.rmFileCacheDir(file, extfl);
                    continue;
                }
                if (file.delete()) continue;
                log.log(Level.SEVERE, "Unable to delete " + file.getAbsolutePath());
            }
        }
        return path.delete();
    }

    public static void traverseDepth(File path, FileFilter filter) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (filter == null) {
            throw new NullPointerException("filter");
        }
        if (!(path.exists() && path.isDirectory() && path.canRead())) {
            throw new IllegalArgumentException(path.getAbsolutePath() + " either does not exist, or is not a readable directory");
        }
        File[] files = FileUtils.listFilesNullSafe(path);
        ArrayList<File> subDirectories = new ArrayList<File>();
        for (File value : files) {
            File file = value;
            if (file.isDirectory()) {
                subDirectories.add(file);
            }
            filter.accept(file);
        }
        if (!subDirectories.isEmpty()) {
            for (File subdir : subDirectories) {
                boolean accepted = filter.accept(subdir);
                if (!accepted || !subdir.isDirectory()) continue;
                FileUtils.traverseDepth(subdir, filter);
            }
        }
    }

    public static boolean renameFile(File src, File dst) {
        Path moved;
        boolean renamed;
        block3: {
            renamed = false;
            boolean win = System.getProperty("os.name").startsWith("Windows");
            if (win && dst.exists() && !dst.delete()) {
                throw new RuntimeException("Could not delete: " + dst.getPath());
            }
            Path srcPath = Paths.get(src.toURI());
            Path dstPath = Paths.get(dst.toURI());
            moved = null;
            try {
                moved = Files.move(srcPath, dstPath, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block3;
                log.log(Level.FINE, "An error occurred when executing atomic file renaming. Falling back to the old File.renameTo() method", e);
            }
        }
        renamed = moved == null || !Files.exists(moved, new LinkOption[0]) ? src.renameTo(dst) : true;
        return renamed;
    }

    public static String printFileTree(File dir) {
        StringBuilder sb = new StringBuilder();
        sb.append(dir.getPath()).append("\n");
        FileUtils.printFileTree_(sb, "", dir);
        return sb.toString();
    }

    private static void printFileTree_(StringBuilder sb, String prefix, File dir) {
        File[] listFile = dir.listFiles();
        if (listFile != null) {
            for (int i = 0; i < listFile.length; ++i) {
                boolean last = i == listFile.length - 1;
                File file = listFile[i];
                String firstChar = last ? "\u2514" : "\u251c";
                sb.append(prefix).append(firstChar).append("\u2500\u2500").append(file.getName()).append("\n");
                if (!file.isDirectory()) continue;
                FileUtils.printFileTree_(sb, prefix + (last ? " " : "|") + "  ", file);
            }
        }
    }

    public static File[] listFilesNullSafe(File layerPath, FileFilter filter) {
        File[] files = layerPath.listFiles(filter);
        if (files != null) {
            return files;
        }
        return NO_FILES;
    }

    public static File[] listFilesNullSafe(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            return files;
        }
        return NO_FILES;
    }

    public static File[] listFilesNullSafe(File layerPath, FilenameFilter tileFinder) {
        File[] files = layerPath.listFiles(tileFinder);
        if (files != null) {
            return files;
        }
        return NO_FILES;
    }

    public static class ExtensionFileLister
    implements FilenameFilter {
        private String prefix;
        private String extension;

        public ExtensionFileLister(String prefix, String extension) {
            this.prefix = prefix;
            this.extension = extension == null ? null : "." + extension;
        }

        @Override
        public boolean accept(File directory, String filename) {
            if (this.prefix != null && !filename.startsWith(this.prefix)) {
                return false;
            }
            if (this.extension != null) {
                return filename.endsWith(this.extension);
            }
            return true;
        }
    }
}

