/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.BlobStoreConfiguration;
import org.geowebcache.config.BlobStoreConfigurationListener;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.ServerConfiguration;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.util.CompositeIterable;
import org.springframework.util.Assert;

public class BlobStoreAggregator {
    private List<BlobStoreConfiguration> configs;
    private static Logger log = Logging.getLogger((String)BlobStoreAggregator.class.getName());
    private ServiceInformation serviceInformation;
    private TileLayerDispatcher layers;

    public BlobStoreAggregator(List<BlobStoreConfiguration> configs, TileLayerDispatcher layers) {
        this.configs = configs == null ? new ArrayList() : configs;
        this.layers = layers;
        this.initialize();
    }

    public BlobStoreAggregator() {
        this.reInit();
    }

    public void addConfiguration(BlobStoreConfiguration config) {
        this.initialize(config);
        ArrayList<BlobStoreConfiguration> newList = new ArrayList<BlobStoreConfiguration>(this.getConfigs());
        newList.add(config);
        this.configs = newList;
    }

    public boolean blobStoreExists(String blobStoreInfoName) {
        for (BlobStoreConfiguration configuration : this.getConfigs()) {
            Optional<BlobStoreInfo> blob = configuration.getBlobStore(blobStoreInfoName);
            if (!blob.isPresent()) continue;
            return true;
        }
        return false;
    }

    public BlobStoreInfo getBlobStore(String blobStoreName) throws GeoWebCacheException {
        Objects.requireNonNull(blobStoreName, "blobStoreName is null");
        return this.getConfigs().stream().map(c -> c.getBlobStore(blobStoreName)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new GeoWebCacheException("Thread " + Thread.currentThread().getId() + " Unknown blob store " + blobStoreName + ". Check the logfiles, it may not have loaded properly."));
    }

    public void reInit() {
        List<BlobStoreConfiguration> extensions = GeoWebCacheExtensions.extensions(BlobStoreConfiguration.class);
        this.configs = new ArrayList<BlobStoreConfiguration>(extensions);
        this.layers = GeoWebCacheExtensions.bean(TileLayerDispatcher.class);
        this.initialize();
    }

    public int getBlobStoreCount() {
        int count = 0;
        for (BlobStoreConfiguration configuration : this.getConfigs()) {
            count += configuration.getBlobStoreCount();
        }
        return count;
    }

    public List<String> getBlobStoreNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (BlobStoreConfiguration configuration : this.getConfigs()) {
            names.addAll(configuration.getBlobStoreNames());
        }
        return names;
    }

    public Iterable<BlobStoreInfo> getBlobStores() {
        ArrayList perConfigBlobStores = new ArrayList(this.getConfigs().size());
        for (BlobStoreConfiguration config : this.getConfigs()) {
            perConfigBlobStores.add(config.getBlobStores());
        }
        return new CompositeIterable<BlobStoreInfo>(perConfigBlobStores);
    }

    private void initialize() {
        log.fine("Thread initBlobStore(), initializing");
        for (BlobStoreConfiguration config : this.getConfigs()) {
            this.initialize(config);
        }
    }

    private int initialize(BlobStoreConfiguration config) {
        String configIdent;
        if (config == null) {
            throw new IllegalStateException("BlobStoreConfiguration got a null GWC configuration object");
        }
        try {
            configIdent = config.getIdentifier();
        }
        catch (Exception gwce) {
            log.log(Level.SEVERE, "Error obtaining identify from BlobStoreConfiguration " + String.valueOf(config), gwce);
            return 0;
        }
        if (configIdent == null) {
            log.warning("Got a GWC configuration with no identity, ignoring it:" + String.valueOf(config));
            return 0;
        }
        int blobStoreCount = config.getBlobStoreCount();
        if (blobStoreCount <= 0) {
            log.config("BlobStoreConfiguration " + config.getIdentifier() + " contained no blob store infos.");
        }
        if (this.serviceInformation == null && config instanceof ServerConfiguration) {
            log.fine("Reading service information.");
            this.serviceInformation = ((ServerConfiguration)((Object)config)).getServiceInformation();
        }
        return blobStoreCount;
    }

    public ServiceInformation getServiceInformation() {
        return this.serviceInformation;
    }

    public void destroy() throws Exception {
    }

    public synchronized void removeBlobStore(String blobStoreName) throws IllegalArgumentException {
        for (BlobStoreConfiguration config : this.getConfigs()) {
            if (!config.containsBlobStore(blobStoreName)) continue;
            config.removeBlobStore(blobStoreName);
            return;
        }
        throw new NoSuchElementException("No configuration found containing blob store " + blobStoreName);
    }

    public synchronized void addBlobStore(BlobStoreInfo bs) throws IllegalArgumentException {
        for (BlobStoreConfiguration c : this.getConfigs()) {
            if (!c.canSave(bs)) continue;
            c.addBlobStore(bs);
            return;
        }
        throw new IllegalArgumentException("No configuration found capable of saving " + String.valueOf(bs));
    }

    public synchronized void renameBlobStore(String oldName, String newName) throws NoSuchElementException, IllegalArgumentException {
        BlobStoreConfiguration config = this.getConfiguration(oldName);
        config.renameBlobStore(oldName, newName);
        for (TileLayer layer : this.layers.getLayerList()) {
            if (!oldName.equals(layer.getBlobStoreId())) continue;
            layer.setBlobStoreId(newName);
            this.layers.modify(layer);
        }
    }

    public synchronized void modifyBlobStore(BlobStoreInfo bs) throws IllegalArgumentException {
        BlobStoreConfiguration config = this.getConfiguration(bs);
        config.modifyBlobStore(bs);
    }

    public BlobStoreConfiguration getConfiguration(BlobStoreInfo bs) throws IllegalArgumentException {
        Assert.notNull((Object)bs, (String)"blobStore is null");
        return this.getConfiguration(bs.getName());
    }

    public BlobStoreConfiguration getConfiguration(String blobStoreName) throws IllegalArgumentException {
        Assert.notNull((Object)blobStoreName, (String)"blobStoreName is null");
        for (BlobStoreConfiguration c : this.getConfigs()) {
            if (!c.containsBlobStore(blobStoreName)) continue;
            return c;
        }
        throw new IllegalArgumentException("No configuration found containing blob store " + blobStoreName);
    }

    public void addListener(BlobStoreConfigurationListener listener) {
        for (BlobStoreConfiguration c : this.getConfigs()) {
            c.addBlobStoreListener(listener);
        }
    }

    public void removeListener(BlobStoreConfigurationListener listener) {
        for (BlobStoreConfiguration c : this.getConfigs()) {
            c.removeBlobStoreListener(listener);
        }
    }

    protected List<BlobStoreConfiguration> getConfigs() {
        return this.configs;
    }
}

