/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.service.OWSException;
import org.geowebcache.service.ServiceException;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.util.ServletUtils;

public abstract class Service {
    private String pathName = null;

    public Service(String pathName) {
        this.pathName = pathName;
    }

    public boolean handlesRequest(HttpServletRequest request) {
        return request.getPathInfo().equalsIgnoreCase(this.pathName);
    }

    public String getPathName() {
        return this.pathName;
    }

    public Conveyor getConveyor(HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException, OWSException {
        throw new ServiceException("Service for " + this.pathName + " needs to override getConveyor(HttpSerlvetRequest,HttpServletResponse)");
    }

    public void handleRequest(Conveyor conv) throws GeoWebCacheException, OWSException {
        throw new RuntimeException("Service for " + this.pathName + " needs to override handleRequest(TileLayerDispatcher, Tile)");
    }

    protected String getLayersParameter(HttpServletRequest request) throws ServiceException {
        String layers = ServletUtils.stringFromMap(request.getParameterMap(), request.getCharacterEncoding(), "layers");
        if (layers == null) {
            throw new ServiceException("Unable to parse layers parameter from request.");
        }
        return layers;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Service) {
            Service other = (Service)obj;
            if (other.pathName != null && other.pathName.equalsIgnoreCase(this.pathName)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.pathName.hashCode();
    }

    protected static void writeTileResponse(ConveyorTile conv, boolean writeExpiration) {
        Service.writeTileResponse(conv, writeExpiration, null, null);
    }

    protected static void writeTileResponse(ConveyorTile conv, boolean writeExpiration, RuntimeStats stats, String mimeTypeOverride) {
        HttpServletResponse response = conv.servletResp;
        Resource data = conv.getBlob();
        String mimeStr = mimeTypeOverride == null ? conv.getMimeType().getMimeType() : mimeTypeOverride;
        response.setCharacterEncoding("utf-8");
        response.setStatus(conv.getStatus());
        TileLayer layer = conv.getLayer();
        if (layer != null) {
            layer.setExpirationHeader(conv.servletResp, (int)conv.getTileIndex()[2]);
        }
        if (writeExpiration) {
            conv.getLayer().setExpirationHeader(response, (int)conv.getTileIndex()[2]);
        }
        response.setContentType(mimeStr);
        int size = (int)data.getSize();
        response.setContentLength(size);
        try (ServletOutputStream os = response.getOutputStream();
             WritableByteChannel channel = Channels.newChannel((OutputStream)os);){
            data.transferTo(channel);
            if (stats != null) {
                stats.log(size, conv.getCacheResult());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

