/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.seed;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.seed.MassTruncateRequest;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;

@XStreamAlias(value="truncateLayer")
public class TruncateLayerRequest
implements MassTruncateRequest {
    private static final Logger log = Logging.getLogger((String)TruncateLayerRequest.class.getName());
    String layerName;

    @Override
    public boolean doTruncate(StorageBroker sb, TileBreeder breeder) throws StorageException {
        try {
            TileLayer tLayer = breeder.findTileLayer(this.layerName);
            for (String gridSetId : tLayer.getGridSubsets()) {
                sb.deleteByGridSetId(this.layerName, gridSetId);
                log.info("Layer: " + this.layerName + ",Truncated Gridset :" + gridSetId);
            }
        }
        catch (GeoWebCacheException e) {
            throw new IllegalArgumentException("Could not find layer " + this.layerName);
        }
        return true;
    }
}

