/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.config.XMLOldGrid;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.ExpirationRule;
import org.geowebcache.layer.LayerListenerList;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerListener;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.meta.MetadataURL;
import org.geowebcache.layer.updatesource.UpdateSourceDefinition;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.mime.MimeType;

public abstract class AbstractTileLayer
extends TileLayer {
    private static Logger log = Logging.getLogger((String)AbstractTileLayer.class.getName());
    private static final int[] DEFAULT_METATILING_FACTORS = new int[]{1, 1};
    @Nullable
    protected String blobStoreId;
    protected Boolean enabled;
    protected Boolean advertised;
    protected Boolean transientLayer;
    protected String name;
    protected LayerMetaInformation metaInformation;
    protected List<MetadataURL> metadataURLs;
    protected List<String> mimeFormats;
    protected List<String> infoMimeFormats;
    protected List<FormatModifier> formatModifiers;
    protected Map<SRS, XMLOldGrid> grids;
    protected List<XMLGridSubset> gridSubsets;
    protected List<UpdateSourceDefinition> updateSources;
    protected List<RequestFilter> requestFilters;
    protected Boolean useETags;
    protected int[] metaWidthHeight;
    protected String expireCache;
    protected ArrayList<ExpirationRule> expireCacheList;
    protected String expireClients;
    protected ArrayList<ExpirationRule> expireClientsList;
    protected Integer backendTimeout;
    protected Boolean cacheBypassAllowed;
    protected Boolean queryable;
    protected List<ParameterFilter> parameterFilters;
    protected transient boolean saveExpirationHeaders;
    protected transient List<MimeType> formats;
    protected transient List<MimeType> infoFormats;
    protected transient Map<String, GridSubset> subSets;
    private transient LayerListenerList listeners;

    protected Object readResolve() {
        if (this.gridSubsets == null) {
            this.gridSubsets = new ArrayList<XMLGridSubset>();
        }
        return this;
    }

    @Override
    public void addLayerListener(TileLayerListener listener) {
        if (this.listeners == null) {
            this.listeners = new LayerListenerList();
        }
        this.listeners.addListener(listener);
    }

    @Override
    public boolean removeLayerListener(TileLayerListener listener) {
        return this.listeners == null ? false : this.listeners.removeListener(listener);
    }

    protected final void sendTileRequestedEvent(ConveyorTile tile) {
        if (this.listeners != null) {
            this.listeners.sendTileRequested(this, tile);
        }
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    @Nullable
    public String getBlobStoreId() {
        return this.blobStoreId;
    }

    @Override
    public void setBlobStoreId(@Nullable String blobStoreId) {
        this.blobStoreId = blobStoreId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled == null ? true : this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isAdvertised() {
        return this.advertised == null ? true : this.advertised;
    }

    @Override
    public void setAdvertised(boolean advertised) {
        this.advertised = advertised;
    }

    @Override
    public boolean isTransientLayer() {
        return this.transientLayer == null ? false : this.transientLayer;
    }

    @Override
    public void setTransientLayer(boolean transientLayer) {
        this.transientLayer = transientLayer;
    }

    @Override
    public LayerMetaInformation getMetaInformation() {
        return this.metaInformation;
    }

    @Override
    public List<MetadataURL> getMetadataURLs() {
        return this.metadataURLs == null ? null : new ArrayList<MetadataURL>(this.metadataURLs);
    }

    @Override
    public Set<String> getGridSubsets() {
        return Collections.unmodifiableSet(this.subSets.keySet());
    }

    @Override
    public final boolean initialize(GridSetBroker gridSetBroker) {
        if (this.expireCacheList == null) {
            this.expireCacheList = new ArrayList(1);
            if (this.expireCache == null) {
                this.expireCacheList.add(new ExpirationRule(0, -2));
            } else {
                int expireCacheInt = Integer.parseInt(this.expireCache);
                if (expireCacheInt == -4) {
                    this.saveExpirationHeaders = true;
                }
                this.expireCacheList.add(new ExpirationRule(0, expireCacheInt));
            }
        }
        if (this.expireClientsList == null) {
            this.expireClientsList = new ArrayList(1);
            if (this.expireClients == null) {
                this.expireClientsList.add(new ExpirationRule(0, 7200));
            } else {
                int expireClientsInt = Integer.parseInt(this.expireClients);
                if (expireClientsInt == -4) {
                    this.saveExpirationHeaders = true;
                } else if (expireClientsInt == -2) {
                    expireClientsInt = 31536000;
                }
                this.expireClientsList.add(new ExpirationRule(0, expireClientsInt));
            }
        }
        try {
            this.formats = new ArrayList<MimeType>();
            if (this.mimeFormats != null) {
                for (String fmt : this.mimeFormats) {
                    this.formats.add(MimeType.createFromFormat(fmt));
                }
            }
            if (this.formats.isEmpty()) {
                this.formats.add(0, MimeType.createFromFormat("image/png"));
                this.formats.add(1, MimeType.createFromFormat("image/jpeg"));
            }
        }
        catch (GeoWebCacheException gwce) {
            log.log(Level.SEVERE, gwce.getMessage(), gwce);
        }
        try {
            this.infoFormats = new ArrayList<MimeType>();
            if (this.infoMimeFormats != null) {
                for (String fmt : this.infoMimeFormats) {
                    this.infoFormats.add(MimeType.createFromFormat(fmt));
                }
            }
            if (this.infoFormats.isEmpty()) {
                this.infoFormats.add(MimeType.createFromFormat("text/plain"));
                this.infoFormats.add(MimeType.createFromFormat("text/html"));
                this.infoFormats.add(MimeType.createFromFormat("application/vnd.ogc.gml"));
            }
        }
        catch (GeoWebCacheException gwce) {
            log.log(Level.SEVERE, gwce.getMessage(), gwce);
        }
        if (this.subSets == null) {
            this.subSets = new HashMap<String, GridSubset>();
        }
        if (this.gridSubsets == null) {
            this.gridSubsets = new ArrayList<XMLGridSubset>();
        }
        for (XMLGridSubset xmlGridSubset : this.gridSubsets) {
            GridSubset gridSubset = xmlGridSubset.getGridSubSet(gridSetBroker);
            if (gridSubset == null) {
                log.log(Level.SEVERE, xmlGridSubset.getGridSetName() + " is not known by the GridSetBroker, skipping for layer " + this.name);
                continue;
            }
            this.subSets.put(gridSubset.getName(), gridSubset);
        }
        if (this.grids != null && !this.grids.isEmpty()) {
            Iterator<XMLOldGrid> iter = this.grids.values().iterator();
            while (iter.hasNext()) {
                GridSubset converted = iter.next().convertToGridSubset(gridSetBroker);
                this.subSets.put(converted.getSRS().toString(), converted);
                this.gridSubsets.add(new XMLGridSubset(converted));
            }
            this.grids = null;
        }
        if (this.subSets.isEmpty()) {
            this.subSets.put(gridSetBroker.getWorldEpsg4326().getName(), GridSubsetFactory.createGridSubSet(gridSetBroker.getWorldEpsg4326()));
            this.subSets.put(gridSetBroker.getWorldEpsg3857().getName(), GridSubsetFactory.createGridSubSet(gridSetBroker.getWorldEpsg3857()));
        }
        return this.initializeInternal(gridSetBroker);
    }

    protected abstract boolean initializeInternal(GridSetBroker var1);

    @Override
    public List<UpdateSourceDefinition> getUpdateSources() {
        List<Object> sources = this.updateSources == null ? Collections.emptyList() : this.updateSources;
        return sources;
    }

    @Override
    public boolean useETags() {
        return this.useETags == null ? false : this.useETags;
    }

    @Override
    public List<FormatModifier> getFormatModifiers() {
        return this.formatModifiers;
    }

    @Override
    public void setFormatModifiers(List<FormatModifier> formatModifiers) {
        this.formatModifiers = formatModifiers;
    }

    @Override
    public abstract String getStyles();

    @Override
    public int[] getMetaTilingFactors() {
        return this.metaWidthHeight == null ? DEFAULT_METATILING_FACTORS : this.metaWidthHeight;
    }

    @Override
    public Boolean isCacheBypassAllowed() {
        return this.cacheBypassAllowed;
    }

    @Override
    public void setCacheBypassAllowed(boolean allowed) {
        this.cacheBypassAllowed = allowed;
    }

    @Override
    public boolean isQueryable() {
        return this.queryable == null ? false : this.queryable;
    }

    @Override
    public Integer getBackendTimeout() {
        return this.backendTimeout;
    }

    @Override
    public void setBackendTimeout(int seconds) {
        this.backendTimeout = seconds;
    }

    public List<String> getMimeFormats() {
        return this.mimeFormats == null ? null : new ArrayList<String>(this.mimeFormats);
    }

    @Override
    public List<MimeType> getMimeTypes() {
        return this.formats;
    }

    public List<String> getInfoMimeFormats() {
        return this.infoMimeFormats == null ? null : new ArrayList<String>(this.infoMimeFormats);
    }

    @Override
    public List<MimeType> getInfoMimeTypes() {
        return this.infoFormats;
    }

    @Override
    public int getExpireClients(int zoomLevel) {
        return this.getExpiration(this.expireClientsList, zoomLevel);
    }

    @Override
    public int getExpireCache(int zoomLevel) {
        return this.getExpiration(this.expireCacheList, zoomLevel);
    }

    private int getExpiration(ArrayList<ExpirationRule> list, int zoomLevel) {
        int retVal;
        int length = list.size();
        if (length == 1) {
            retVal = list.get(0).getExpiration();
        } else {
            int i;
            for (i = 1; i < length && list.get(i).getMinZoom() <= zoomLevel; ++i) {
            }
            retVal = list.get(i - 1).getExpiration();
        }
        if (retVal == -4) {
            return 7200;
        }
        return retVal;
    }

    @Override
    public List<ParameterFilter> getParameterFilters() {
        return this.parameterFilters;
    }

    @Override
    public List<RequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    @Override
    public GridSubset getGridSubset(String gridSetId) {
        return this.subSets.get(gridSetId);
    }

    @Override
    public synchronized GridSubset removeGridSubset(String gridSetId) {
        Iterator<XMLGridSubset> it = this.gridSubsets.iterator();
        while (it.hasNext()) {
            XMLGridSubset configSubset = it.next();
            if (!gridSetId.equals(configSubset.getGridSetName())) continue;
            it.remove();
            break;
        }
        return this.subSets.remove(gridSetId);
    }

    @Override
    public synchronized void addGridSubset(GridSubset gridSubset) {
        this.removeGridSubset(gridSubset.getName());
        this.gridSubsets.add(new XMLGridSubset(gridSubset));
        this.subSets.put(gridSubset.getName(), gridSubset);
    }
}

