/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.request;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;

public class GreenTileException
extends RequestFilterException {
    private static final long serialVersionUID = -3369293469656922254L;
    private static Logger log = Logging.getLogger((String)GreenTileException.class.getName());
    private static volatile Resource greenTile;

    public GreenTileException(RequestFilter reqFilter) {
        super(reqFilter, 200, "image/png");
    }

    private Resource getGreenTile() {
        byte[] green = new byte[659];
        try (InputStream is = GreenTileException.class.getResourceAsStream("green.png");){
            int ret = is.read(green);
            log.info("Read " + ret + " from gree PNG file (expected 659).");
        }
        catch (IOException ioe) {
            log.log(Level.SEVERE, ioe.getMessage());
        }
        return new ByteArrayResource(green);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Resource getResponse() {
        Resource ret = greenTile;
        if (ret != null) return ret;
        Class<GreenTileException> clazz = GreenTileException.class;
        synchronized (GreenTileException.class) {
            ret = greenTile;
            if (greenTile != null) return ret;
            greenTile = ret = this.getGreenTile();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }
}

