/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.geowebcache.filter.parameters.CaseNormalizingParameterFilter;
import org.geowebcache.filter.parameters.ParameterException;

@ParametersAreNonnullByDefault
@XStreamAlias(value="stringParameterFilter")
public class StringParameterFilter
extends CaseNormalizingParameterFilter {
    private static final long serialVersionUID = 7383381085250203901L;
    private List<String> values = new ArrayList<String>();

    @Override
    protected Object readResolve() {
        super.readResolve();
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String value : this.values) {
            Preconditions.checkNotNull((Object)value, (Object)"Value list included a null pointer.");
        }
        return this;
    }

    @Override
    public String apply(@Nullable String str) throws ParameterException {
        if (str == null || str.length() == 0) {
            return this.getDefaultValue();
        }
        str = this.getNormalize().apply(str);
        if (this.getLegalValues().contains(str)) {
            return str;
        }
        throw new ParameterException(str + " violates filter for parameter " + this.getKey());
    }

    @Override
    public List<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public void setValues(List<String> values) {
        Preconditions.checkNotNull(values);
        for (String value : values) {
            Preconditions.checkNotNull((Object)value, (Object)"Value list included a null pointer.");
        }
        this.values = new ArrayList<String>(values);
    }

    @Override
    public boolean applies(@Nullable String parameterValue) {
        return this.getLegalValues().contains(this.getNormalize().apply(parameterValue));
    }

    @Override
    public StringParameterFilter clone() {
        StringParameterFilter clone = (StringParameterFilter)super.clone();
        if (this.values != null) {
            clone.values = new ArrayList<String>(this.values);
        }
        if (this.normalize != null) {
            clone.setNormalize(this.normalize.clone());
        }
        return clone;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringParameterFilter other = (StringParameterFilter)obj;
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    @Override
    public String toString() {
        return "StringParameterFilter [values=" + String.valueOf(this.values) + ", " + super.toString() + "]";
    }
}

