/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config.legends;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.geowebcache.config.legends.LegendRawInfo;
import org.geowebcache.config.legends.LegendsRawInfo;

public class LegendsRawInfoConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        LegendsRawInfo legendsRawInfo = (LegendsRawInfo)source;
        writer.addAttribute("defaultWidth", String.valueOf(legendsRawInfo.getDefaultWidth()));
        writer.addAttribute("defaultHeight", String.valueOf(legendsRawInfo.getDefaultHeight()));
        writer.addAttribute("defaultFormat", String.valueOf(legendsRawInfo.getDefaultFormat()));
        for (LegendRawInfo legendRawInfo : legendsRawInfo.getLegendsRawInfo()) {
            writer.startNode("legend");
            writer.addAttribute("style", legendRawInfo.getStyle());
            this.encodeAttribute(writer, "width", legendRawInfo.getWidth());
            this.encodeAttribute(writer, "height", legendRawInfo.getHeight());
            this.encodeAttribute(writer, "format", legendRawInfo.getFormat());
            this.encodeAttribute(writer, "url", legendRawInfo.getUrl());
            this.encodeAttribute(writer, "completeUrl", legendRawInfo.getCompleteUrl());
            this.encodeAttribute(writer, "minScale", legendRawInfo.getMinScale());
            this.encodeAttribute(writer, "maxScale", legendRawInfo.getMaxScale());
            writer.endNode();
        }
    }

    private void encodeAttribute(HierarchicalStreamWriter writer, String name, Object value) {
        if (value == null) {
            return;
        }
        writer.startNode(name);
        writer.setValue(value.toString());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        LegendsRawInfo legendsRawInfo = new LegendsRawInfo();
        legendsRawInfo.setDefaultWidth(this.toInteger(reader.getAttribute("defaultWidth")));
        legendsRawInfo.setDefaultHeight(this.toInteger(reader.getAttribute("defaultHeight")));
        legendsRawInfo.setDefaultFormat(reader.getAttribute("defaultFormat"));
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            legendsRawInfo.addLegendRawInfo(this.parseLegendRawInfo(reader));
            reader.moveUp();
        }
        return legendsRawInfo;
    }

    private Integer toInteger(String rawValue) {
        if (rawValue == null) {
            return null;
        }
        return Integer.valueOf(rawValue);
    }

    private Double toDouble(String rawValue) {
        if (rawValue == null) {
            return null;
        }
        return Double.valueOf(rawValue);
    }

    private LegendRawInfo parseLegendRawInfo(HierarchicalStreamReader reader) {
        LegendRawInfo legendRawInfo = new LegendRawInfo();
        legendRawInfo.setStyle(reader.getAttribute("style"));
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            switch (reader.getNodeName()) {
                case "width": {
                    legendRawInfo.setWidth(this.toInteger(reader.getValue()));
                    break;
                }
                case "height": {
                    legendRawInfo.setHeight(this.toInteger(reader.getValue()));
                    break;
                }
                case "format": {
                    legendRawInfo.setFormat(reader.getValue());
                    break;
                }
                case "url": {
                    legendRawInfo.setUrl(reader.getValue());
                    break;
                }
                case "completeUrl": {
                    legendRawInfo.setCompleteUrl(reader.getValue());
                    break;
                }
                case "minScale": {
                    legendRawInfo.setMinScale(this.toDouble(reader.getValue()));
                    break;
                }
                case "maxScale": {
                    legendRawInfo.setMaxScale(this.toDouble(reader.getValue()));
                }
            }
            reader.moveUp();
        }
        return legendRawInfo;
    }

    public boolean canConvert(Class type) {
        return type.equals(LegendsRawInfo.class);
    }
}

