/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;

public class XMLGridSubset
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2758612849329765806L;
    private static Logger log = Logging.getLogger((String)XMLGridSubset.class.getName());
    private String gridSetName;
    private BoundingBox extent;
    private Integer zoomStart;
    private Integer zoomStop;
    private Integer minCachedLevel;
    private Integer maxCachedLevel;

    public XMLGridSubset() {
        this.readResolve();
    }

    private Object readResolve() {
        return this;
    }

    public XMLGridSubset(XMLGridSubset sset) {
        this.setGridSetName(sset.getGridSetName());
        this.setExtent(sset.getExtent() == null ? null : new BoundingBox(sset.getExtent()));
        this.setZoomStart(sset.getZoomStart());
        this.setZoomStop(sset.getZoomStop());
        this.setMinCachedLevel(sset.getMinCachedLevel());
        this.setMaxCachedLevel(sset.getMaxCachedLevel());
    }

    public XMLGridSubset(GridSubset sset) {
        this.setGridSetName(sset.getName());
        this.setExtent(sset.getOriginalExtent() == null ? null : new BoundingBox(sset.getOriginalExtent()));
        this.setZoomStart(sset.getZoomStart());
        this.setZoomStop(sset.getZoomStop());
        this.setMinCachedLevel(sset.getMinCachedZoom());
        this.setMaxCachedLevel(sset.getMaxCachedZoom());
    }

    public XMLGridSubset clone() {
        return new XMLGridSubset(this);
    }

    public GridSubset getGridSubSet(GridSetBroker gridSetBroker) {
        GridSet gridSet = gridSetBroker.get(this.getGridSetName());
        if (gridSet == null) {
            log.log(Level.SEVERE, "Unable to find GridSet for \"" + this.getGridSetName() + "\"");
            return null;
        }
        return GridSubsetFactory.createGridSubSet(gridSet, this.getExtent(), this.getZoomStart(), this.getZoomStop(), this.minCachedLevel, this.maxCachedLevel);
    }

    public String getGridSetName() {
        return this.gridSetName;
    }

    public void setGridSetName(String gridSetName) {
        this.gridSetName = gridSetName;
    }

    public BoundingBox getExtent() {
        return this.extent;
    }

    public void setExtent(BoundingBox extent) {
        this.extent = extent;
    }

    public Integer getZoomStart() {
        return this.zoomStart;
    }

    public void setZoomStart(Integer zoomStart) {
        this.zoomStart = zoomStart;
    }

    public Integer getZoomStop() {
        return this.zoomStop;
    }

    public void setZoomStop(Integer zoomStop) {
        this.zoomStop = zoomStop;
    }

    public Integer getMinCachedLevel() {
        return this.minCachedLevel;
    }

    public void setMinCachedLevel(Integer minCachedLevel) {
        this.minCachedLevel = minCachedLevel;
    }

    public Integer getMaxCachedLevel() {
        return this.maxCachedLevel;
    }

    public void setMaxCachedLevel(Integer maxCachedLevel) {
        this.maxCachedLevel = maxCachedLevel;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.extent == null ? 0 : this.extent.hashCode());
        result = 31 * result + (this.gridSetName == null ? 0 : this.gridSetName.hashCode());
        result = 31 * result + (this.maxCachedLevel == null ? 0 : this.maxCachedLevel.hashCode());
        result = 31 * result + (this.minCachedLevel == null ? 0 : this.minCachedLevel.hashCode());
        result = 31 * result + (this.zoomStart == null ? 0 : this.zoomStart.hashCode());
        result = 31 * result + (this.zoomStop == null ? 0 : this.zoomStop.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLGridSubset other = (XMLGridSubset)obj;
        if (this.extent == null ? other.extent != null : !this.extent.equals(other.extent)) {
            return false;
        }
        if (this.gridSetName == null ? other.gridSetName != null : !this.gridSetName.equals(other.gridSetName)) {
            return false;
        }
        if (this.maxCachedLevel == null ? other.maxCachedLevel != null : !this.maxCachedLevel.equals(other.maxCachedLevel)) {
            return false;
        }
        if (this.minCachedLevel == null ? other.minCachedLevel != null : !this.minCachedLevel.equals(other.minCachedLevel)) {
            return false;
        }
        if (this.zoomStart == null ? other.zoomStart != null : !this.zoomStart.equals(other.zoomStart)) {
            return false;
        }
        return !(this.zoomStop == null ? other.zoomStop != null : !this.zoomStop.equals(other.zoomStop));
    }

    public String toString() {
        return "XMLGridSubset [gridSetName=" + this.gridSetName + ", extent=" + String.valueOf(this.extent) + ", zoomStart=" + this.zoomStart + ", zoomStop=" + this.zoomStop + ", minCachedLevel=" + this.minCachedLevel + ", maxCachedLevel=" + this.maxCachedLevel + "]";
    }
}

