/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.BlobStoreConfiguration;
import org.geowebcache.config.BlobStoreConfigurationListener;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.ConfigurationPersistenceException;
import org.geowebcache.config.ConfigurationResourceProvider;
import org.geowebcache.config.ContextualConfigurationProvider;
import org.geowebcache.config.DefaultingConfiguration;
import org.geowebcache.config.FileBlobStoreInfo;
import org.geowebcache.config.GeoWebCacheConfiguration;
import org.geowebcache.config.GridSetConfiguration;
import org.geowebcache.config.ListenerCollection;
import org.geowebcache.config.ServerConfiguration;
import org.geowebcache.config.TileLayerConfiguration;
import org.geowebcache.config.XMLConfigurationProvider;
import org.geowebcache.config.XMLFileResourceProvider;
import org.geowebcache.config.XMLGridSet;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.config.XMLOldGrid;
import org.geowebcache.config.legends.LegendsRawInfo;
import org.geowebcache.config.legends.LegendsRawInfoConverter;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.filter.parameters.CaseNormalizer;
import org.geowebcache.filter.parameters.FloatParameterFilter;
import org.geowebcache.filter.parameters.IntegerParameterFilter;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.filter.request.CircularExtentFilter;
import org.geowebcache.filter.request.FileRasterFilter;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.filter.request.WMSRasterFilter;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.GeoWebCacheXStream;
import org.geowebcache.layer.ExpirationRule;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.meta.ContactInformation;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.updatesource.GeoRSSFeedDefinition;
import org.geowebcache.layer.wms.WMSHttpHelper;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.seed.TruncateAllRequest;
import org.geowebcache.seed.TruncateLayerRequest;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.UnsuitableStorageException;
import org.geowebcache.util.ApplicationContextProvider;
import org.geowebcache.util.ExceptionUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLConfiguration
implements TileLayerConfiguration,
InitializingBean,
DefaultingConfiguration,
ServerConfiguration,
BlobStoreConfiguration,
GridSetConfiguration {
    public static final String DEFAULT_CONFIGURATION_FILE_NAME = "geowebcache.xml";
    private static Logger log = Logging.getLogger((String)XMLConfiguration.class.getName());
    private final WebApplicationContext context;
    private final ConfigurationResourceProvider resourceProvider;
    private volatile GeoWebCacheConfiguration gwcConfig;
    private transient Map<String, TileLayer> layers;
    private transient Map<String, GridSet> gridSets;
    private GridSetBroker gridSetBroker;
    private ListenerCollection<BlobStoreConfigurationListener> blobStoreListeners = new ListenerCollection();

    public XMLConfiguration(ApplicationContextProvider appCtx, ConfigurationResourceProvider inFac) {
        this.context = appCtx == null ? null : appCtx.getApplicationContext();
        this.resourceProvider = inFac;
    }

    public XMLConfiguration(ApplicationContextProvider appCtx, String configFileDirectory, DefaultStorageFinder storageDirFinder) throws ConfigurationException {
        this(appCtx, new XMLFileResourceProvider(DEFAULT_CONFIGURATION_FILE_NAME, appCtx, configFileDirectory, storageDirFinder));
        this.resourceProvider.setTemplate("/geowebcache.xml");
    }

    public XMLConfiguration(ApplicationContextProvider appCtx, DefaultStorageFinder storageDirFinder) throws ConfigurationException {
        this(appCtx, new XMLFileResourceProvider(DEFAULT_CONFIGURATION_FILE_NAME, appCtx, storageDirFinder));
        this.resourceProvider.setTemplate("/geowebcache.xml");
    }

    public XMLConfiguration(ApplicationContextProvider appCtx, String configFileDirectory) throws ConfigurationException {
        this(appCtx, configFileDirectory, null);
    }

    public void setTemplate(String template) {
        this.resourceProvider.setTemplate(template);
    }

    public String getConfigLocation() throws ConfigurationException {
        try {
            return this.resourceProvider.getLocation();
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean isRuntimeStatsEnabled() {
        if (this.getGwcConfig() == null || this.getGwcConfig().getRuntimeStats() == null) {
            return true;
        }
        return this.getGwcConfig().getRuntimeStats();
    }

    @Override
    public void setRuntimeStatsEnabled(Boolean isEnabled) throws IOException {
        this.getGwcConfig().setRuntimeStats(isEnabled);
        this.save();
    }

    @Override
    public synchronized ServiceInformation getServiceInformation() {
        return this.getGwcConfig().getServiceInformation();
    }

    @Override
    public void setServiceInformation(ServiceInformation serviceInfo) throws IOException {
        this.getGwcConfig().setServiceInformation(serviceInfo);
        this.save();
    }

    @Override
    public void setDefaultValues(TileLayer layer) {
        if (layer.isCacheBypassAllowed() == null) {
            if (this.getGwcConfig().getCacheBypassAllowed() != null) {
                layer.setCacheBypassAllowed(this.getGwcConfig().getCacheBypassAllowed());
            } else {
                layer.setCacheBypassAllowed(false);
            }
        }
        if (layer.getBackendTimeout() == null) {
            if (this.getGwcConfig().getBackendTimeout() != null) {
                layer.setBackendTimeout(this.getGwcConfig().getBackendTimeout());
            } else {
                layer.setBackendTimeout(120);
            }
        }
        if (layer.getFormatModifiers() == null && this.getGwcConfig().getFormatModifiers() != null) {
            layer.setFormatModifiers(this.getGwcConfig().getFormatModifiers());
        }
        if (layer instanceof WMSLayer) {
            WMSHttpHelper sourceHelper;
            WMSLayer wl = (WMSLayer)layer;
            URL proxyUrl = null;
            try {
                if (this.getGwcConfig().getProxyUrl() != null) {
                    proxyUrl = new URL(this.getGwcConfig().getProxyUrl());
                    log.fine("Using proxy " + proxyUrl.getHost() + ":" + proxyUrl.getPort());
                } else if (wl.getProxyUrl() != null) {
                    proxyUrl = new URL(wl.getProxyUrl());
                    log.fine("Using proxy " + proxyUrl.getHost() + ":" + proxyUrl.getPort());
                }
            }
            catch (MalformedURLException e) {
                log.log(Level.SEVERE, "could not parse proxy URL " + wl.getProxyUrl() + " ! continuing WITHOUT proxy!", e);
            }
            if (wl.getHttpUsername() != null) {
                sourceHelper = new WMSHttpHelper(wl.getHttpUsername(), wl.getHttpPassword(), proxyUrl);
                log.fine("Using per-layer HTTP credentials for " + wl.getName() + ", username " + wl.getHttpUsername());
            } else if (this.getGwcConfig().getHttpUsername() != null) {
                sourceHelper = new WMSHttpHelper(this.getGwcConfig().getHttpUsername(), this.getGwcConfig().getHttpPassword(), proxyUrl);
                log.fine("Using global HTTP credentials for " + wl.getName());
            } else {
                sourceHelper = new WMSHttpHelper(null, null, proxyUrl);
                log.fine("Not using HTTP credentials for " + wl.getName());
            }
            wl.setSourceHelper(sourceHelper);
            wl.setLockProvider(this.getGwcConfig().getLockProvider());
        }
    }

    private GeoWebCacheConfiguration loadConfiguration() throws ConfigurationException {
        GeoWebCacheConfiguration geoWebCacheConfiguration;
        block8: {
            Assert.isTrue((boolean)this.resourceProvider.hasInput(), (String)"Resource provider must have an input");
            InputStream in = this.resourceProvider.in();
            try {
                geoWebCacheConfiguration = this.loadConfiguration(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConfigurationException("Error parsing config file " + this.resourceProvider.getId(), e);
                }
            }
            in.close();
        }
        return geoWebCacheConfiguration;
    }

    private GeoWebCacheConfiguration loadConfiguration(InputStream xmlFile) throws IOException, ConfigurationException {
        Node rootNode = XMLConfiguration.loadDocument(xmlFile);
        XStream xs = this.getConfiguredXStreamWithContext(new GeoWebCacheXStream(), ContextualConfigurationProvider.Context.PERSIST);
        GeoWebCacheConfiguration config = (GeoWebCacheConfiguration)xs.unmarshal((HierarchicalStreamReader)new DomReader((Element)rootNode));
        return config;
    }

    private synchronized void save() throws IOException {
        if (!this.resourceProvider.hasOutput()) {
            return;
        }
        try {
            this.resourceProvider.backup();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error creating back up of configuration file " + this.resourceProvider.getId(), e);
        }
        this.persistToFile();
    }

    public XStream getConfiguredXStream(XStream xs) {
        return XMLConfiguration.getConfiguredXStreamWithContext(xs, this.context, null);
    }

    public static XStream getConfiguredXStream(XStream xs, WebApplicationContext context) {
        return XMLConfiguration.getConfiguredXStreamWithContext(xs, context, null);
    }

    public XStream getConfiguredXStreamWithContext(XStream xs, ContextualConfigurationProvider.Context providerContext) {
        return XMLConfiguration.getConfiguredXStreamWithContext(xs, this.context, providerContext);
    }

    public static XStream getConfiguredXStreamWithContext(XStream xs, WebApplicationContext context, ContextualConfigurationProvider.Context providerContext) {
        xs.allowTypeHierarchy(TileLayer.class);
        xs.allowTypeHierarchy(ParameterFilter.class);
        xs.allowTypeHierarchy(RequestFilter.class);
        xs.allowTypeHierarchy(BlobStoreInfo.class);
        xs.allowTypeHierarchy(TileLayerConfiguration.class);
        xs.allowTypesByWildcard(new String[]{"org.geowebcache.**"});
        xs.setMode(1001);
        xs.addDefaultImplementation(ArrayList.class, List.class);
        xs.alias("gwcConfiguration", GeoWebCacheConfiguration.class);
        xs.useAttributeFor(GeoWebCacheConfiguration.class, "xmlns_xsi");
        xs.aliasField("xmlns:xsi", GeoWebCacheConfiguration.class, "xmlns_xsi");
        xs.useAttributeFor(GeoWebCacheConfiguration.class, "xsi_schemaLocation");
        xs.aliasField("xsi:schemaLocation", GeoWebCacheConfiguration.class, "xsi_schemaLocation");
        xs.useAttributeFor(GeoWebCacheConfiguration.class, "xmlns");
        xs.alias("wmsLayer", WMSLayer.class);
        xs.registerConverter((Converter)new LegendsRawInfoConverter());
        xs.alias("legends", LegendsRawInfo.class);
        xs.alias("blobStores", new ArrayList().getClass());
        xs.alias("FileBlobStore", FileBlobStoreInfo.class);
        xs.aliasAttribute(BlobStoreInfo.class, "_default", "default");
        xs.aliasField("id", BlobStoreInfo.class, "name");
        xs.alias("grids", new ArrayList().getClass());
        xs.alias("grid", XMLOldGrid.class);
        xs.alias("gridSet", XMLGridSet.class);
        xs.alias("gridSubset", XMLGridSubset.class);
        xs.alias("mimeFormats", new ArrayList().getClass());
        xs.alias("formatModifiers", new ArrayList().getClass());
        xs.alias("srs", SRS.class);
        xs.alias("parameterFilters", new ArrayList().getClass());
        xs.alias("parameterFilter", ParameterFilter.class);
        xs.alias("seedRequest", SeedRequest.class);
        xs.processAnnotations(CaseNormalizer.class);
        xs.processAnnotations(StringParameterFilter.class);
        xs.processAnnotations(RegexParameterFilter.class);
        xs.processAnnotations(FloatParameterFilter.class);
        xs.processAnnotations(IntegerParameterFilter.class);
        xs.alias("formatModifier", FormatModifier.class);
        xs.alias("circularExtentFilter", CircularExtentFilter.class);
        xs.alias("wmsRasterFilter", WMSRasterFilter.class);
        xs.alias("fileRasterFilter", FileRasterFilter.class);
        xs.alias("expirationRule", ExpirationRule.class);
        xs.useAttributeFor(ExpirationRule.class, "minZoom");
        xs.useAttributeFor(ExpirationRule.class, "expiration");
        xs.alias("geoRssFeed", GeoRSSFeedDefinition.class);
        xs.alias("metaInformation", LayerMetaInformation.class);
        xs.alias("serviceInformation", ServiceInformation.class);
        xs.alias("contactInformation", ContactInformation.class);
        xs.omitField(ServiceInformation.class, "citeCompliant");
        xs.processAnnotations(TruncateLayerRequest.class);
        xs.processAnnotations(TruncateAllRequest.class);
        if (context != null) {
            List<XMLConfigurationProvider> configExtensions = GeoWebCacheExtensions.extensions(XMLConfigurationProvider.class, (ApplicationContext)context);
            for (XMLConfigurationProvider extension : configExtensions) {
                if (extension instanceof ContextualConfigurationProvider && (providerContext == null || !((ContextualConfigurationProvider)extension).appliesTo(providerContext))) continue;
                xs = extension.getConfiguredXStream(xs);
            }
        }
        return xs;
    }

    private void persistToFile() throws IOException {
        Assert.isTrue((boolean)this.resourceProvider.hasOutput(), (String)"Resource provider must have an output");
        XStream xs = this.getConfiguredXStreamWithContext(new GeoWebCacheXStream(), ContextualConfigurationProvider.Context.PERSIST);
        try (OutputStreamWriter writer = new OutputStreamWriter(this.resourceProvider.out(), StandardCharsets.UTF_8);){
            String currentSchemaVersion = XMLConfiguration.getCurrentSchemaVersion();
            this.getGwcConfig().setVersion(currentSchemaVersion);
            writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            xs.toXML((Object)this.getGwcConfig(), (Writer)writer);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IOException(uee.getMessage(), uee);
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException e) {
            throw (IOException)new IOException("Error writing to " + this.resourceProvider.getId() + ": " + e.getMessage()).initCause(e);
        }
        log.info("Wrote configuration to " + this.resourceProvider.getId());
    }

    @Override
    public boolean canSave(TileLayer tl) {
        if (tl.isTransientLayer()) {
            return false;
        }
        return this.canSaveIfNotTransient(tl);
    }

    protected boolean canSaveIfNotTransient(TileLayer tl) {
        if (tl instanceof WMSLayer) {
            return true;
        }
        return GeoWebCacheExtensions.extensions(XMLConfigurationProvider.class, (ApplicationContext)this.context).stream().anyMatch(provider -> provider.canSave(tl));
    }

    @Override
    public synchronized void addLayer(TileLayer tl) throws IllegalArgumentException {
        if (tl == null) {
            throw new NullPointerException();
        }
        if (!this.canSaveIfNotTransient(tl)) {
            throw new IllegalArgumentException("Can't add layers of type " + tl.getClass().getName());
        }
        if (this.getLayer(tl.getName()).isPresent()) {
            throw new IllegalArgumentException("Layer '" + tl.getName() + "' already exists");
        }
        this.initialize(tl);
        this.getGwcConfig().getLayers().add(tl);
        this.updateLayers();
        try {
            this.save();
        }
        catch (IOException e) {
            if (this.getGwcConfig().getLayers().remove(tl)) {
                this.updateLayers();
            }
            throw new ConfigurationPersistenceException("Unable to add layer " + tl.getName(), e);
        }
    }

    @Override
    public synchronized void modifyLayer(TileLayer tl) throws NoSuchElementException {
        TileLayer previous = this.findLayer(tl.getName());
        if (!this.canSaveIfNotTransient(tl)) {
            throw new IllegalArgumentException("Can't add layers of type " + tl.getClass().getName());
        }
        this.getGwcConfig().getLayers().remove(previous);
        this.initialize(tl);
        this.getGwcConfig().getLayers().add(tl);
        this.updateLayers();
        try {
            this.save();
        }
        catch (IOException e) {
            this.getGwcConfig().getLayers().remove(tl);
            this.initialize(previous);
            this.getGwcConfig().getLayers().add(previous);
            this.updateLayers();
            throw new IllegalArgumentException("Unable to modify layer " + tl.getName(), e);
        }
    }

    protected TileLayer findLayer(String layerName) throws NoSuchElementException {
        TileLayer layer = this.getLayer(layerName).orElseThrow(() -> new NoSuchElementException("Layer " + layerName + " does not exist"));
        return layer;
    }

    @Override
    public void renameLayer(String oldName, String newName) throws NoSuchElementException, IllegalArgumentException {
        throw new UnsupportedOperationException("renameLayer is not supported by " + this.getClass().getSimpleName());
    }

    @Override
    public synchronized void removeLayer(String layerName) throws NoSuchElementException, IllegalArgumentException {
        TileLayer tileLayer = this.findLayer(layerName);
        if (tileLayer == null) {
            throw new NoSuchElementException("Layer " + layerName + " does not exist");
        }
        boolean removed = this.getGwcConfig().getLayers().remove(tileLayer);
        if (!removed) {
            throw new NoSuchElementException("Layer " + tileLayer.getName() + " does not exist");
        }
        this.updateLayers();
        try {
            this.save();
        }
        catch (IOException e) {
            if (this.getGwcConfig().getLayers().add(tileLayer)) {
                this.updateLayers();
            }
            throw new IllegalArgumentException("Unable to remove layer " + String.valueOf(tileLayer), e);
        }
    }

    private synchronized void addOrReplaceGridSet(XMLGridSet gridSet) throws IllegalArgumentException {
        String gridsetName = gridSet.getName();
        List<XMLGridSet> xmlGridSets = this.getGwcConfig().getGridSets();
        xmlGridSets.removeIf(xgs -> gridsetName.equals(xgs.getName()));
        xmlGridSets.add(gridSet);
    }

    static Node loadDocument(InputStream xmlFile) throws ConfigurationException, IOException {
        Node topNode = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            topNode = XMLConfiguration.checkAndTransform(docBuilder.parse(xmlFile));
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        return topNode;
    }

    private static Node checkAndTransform(Document doc) throws ConfigurationException {
        Node rootNode = doc.getDocumentElement();
        if (!rootNode.getNodeName().equals("gwcConfiguration")) {
            log.config("The configuration file is of the pre 1.0 type, trying to convert.");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_pre10.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.0.0")) {
            log.config("Updating configuration from 1.0.0 to 1.0.1");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_100.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.0.1")) {
            log.config("Updating configuration from 1.0.1 to 1.0.2");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_101.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.0.2")) {
            log.config("Updating configuration from 1.0.2 to 1.1.0");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_102.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.1.0")) {
            log.config("Updating configuration from 1.1.0 to 1.1.3");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_110.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.1.3")) {
            log.config("Updating configuration from 1.1.3 to 1.1.4");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_113.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.1.4")) {
            log.config("Updating configuration from 1.1.4 to 1.1.5");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_114.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.1.5")) {
            log.config("Updating configuration from 1.1.5 to 1.2.0");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_115.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.2.0")) {
            log.config("Updating configuration from 1.2.0 to 1.2.1");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_120.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.2.1")) {
            log.config("Updating configuration from 1.2.1 to 1.2.2");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_121.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.2.2")) {
            log.config("Updating configuration from 1.2.2 to 1.2.4");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_122.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.2.4")) {
            log.config("Updating configuration from 1.2.4 to 1.2.5");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_124.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.2.5")) {
            log.config("Updating configuration from 1.2.5 to 1.2.6");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_125.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.2.6")) {
            log.config("Updating configuration from 1.2.6 to 1.5.0");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_126.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.5.0")) {
            log.config("Updating configuration from 1.5.0 to 1.5.1");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_150.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.5.1")) {
            log.config("Updating configuration from 1.5.1 to 1.6.0");
            rootNode = XMLConfiguration.applyTransform(rootNode, "geowebcache_151.xsl").getFirstChild();
        }
        if (!rootNode.getNodeName().equals("gwcConfiguration")) {
            log.log(Level.SEVERE, "Unable to parse file, expected gwcConfiguration at root after transform.");
            throw new ConfigurationException("Unable to parse after transform.");
        }
        try {
            XMLConfiguration.validate(rootNode);
            log.config("TileLayerConfiguration file validated fine.");
        }
        catch (SAXException e) {
            log.warning("GWC configuration validation error: " + e.getMessage());
            log.warning("Will try to use configuration anyway. Please check the order of declared elements against the schema.");
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return rootNode;
    }

    static void validate(Node rootNode) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try (InputStream is = XMLConfiguration.class.getResourceAsStream("geowebcache.xsd");){
            Schema schema = factory.newSchema(new StreamSource(is));
            Validator validator = schema.newValidator();
            DOMSource domSrc = new DOMSource(rootNode);
            validator.validate(domSrc);
        }
    }

    static String getCurrentSchemaVersion() {
        Document dom;
        try (InputStream is = XMLConfiguration.class.getResourceAsStream("geowebcache.xsd");){
            dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String version = dom.getDocumentElement().getAttribute("version");
        if (null == version || version.trim().length() == 0) {
            throw new IllegalStateException("Schema doesn't define version");
        }
        return version.trim();
    }

    private static Node applyTransform(Node oldRootNode, String xslFilename) {
        Node node;
        block10: {
            DOMResult result = new DOMResult();
            InputStream is = XMLConfiguration.class.getResourceAsStream(xslFilename);
            try {
                try {
                    Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(is));
                    transformer.transform(new DOMSource(oldRootNode), result);
                }
                catch (TransformerException | TransformerFactoryConfigurationError e) {
                    log.log(Level.FINE, e.getMessage(), e);
                }
                node = result.getNode();
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return node;
    }

    public void afterPropertiesSet() throws GeoWebCacheException {
        if (this.gridSetBroker == null) {
            throw new IllegalStateException("GridSetBroker has not been set");
        }
        if (this.resourceProvider.hasInput()) {
            this.setGwcConfig(this.loadConfiguration());
        }
        log.config("Initializing GridSets from " + this.getIdentifier());
        this.getGridSetsInternal();
        log.config("Initializing layers from " + this.getIdentifier());
        for (TileLayer layer : this.getGwcConfig().getLayers()) {
            if (layer == null) {
                throw new IllegalStateException(this.getIdentifier() + " contains a null layer");
            }
            this.initialize(layer);
        }
        this.updateLayers();
    }

    private void updateLayers() {
        HashMap<String, TileLayer> buff = new HashMap<String, TileLayer>();
        for (TileLayer layer : this.getGwcConfig().getLayers()) {
            buff.put(layer.getName(), layer);
        }
        this.layers = buff;
    }

    private void loadGridSets() {
        if (this.getGwcConfig().getGridSets() != null) {
            this.gridSets = this.getGwcConfig().getGridSets().stream().map(xmlGridSet -> {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Reading " + xmlGridSet.getName());
                }
                GridSet gridSet = xmlGridSet.makeGridSet();
                log.info("Read GridSet " + gridSet.getName());
                return gridSet;
            }).collect(Collectors.toMap(GridSet::getName, Function.identity(), (x, y) -> {
                throw new IllegalStateException("Gridsets with duplicate name " + x.getName());
            }, HashMap::new));
        }
    }

    private void initialize(TileLayer layer) {
        log.info("Initializing TileLayer '" + layer.getName() + "'");
        this.setDefaultValues(layer);
        layer.initialize(this.gridSetBroker);
    }

    @Override
    public String getIdentifier() {
        return this.resourceProvider.getId();
    }

    public void setRelativePath(String relPath) {
        log.log(Level.SEVERE, "Specifying the relative path as a property is deprecated. Please pass it as the 4th argument to the constructor.");
    }

    public void setAbsolutePath(String absPath) {
        log.log(Level.SEVERE, "Specifying the absolute path as a property is deprecated. Please pass it as the 4th argument to the constructor.");
    }

    public Collection<TileLayer> getLayers() {
        return Collections.unmodifiableList(this.getGwcConfig().getLayers());
    }

    @Override
    public Optional<TileLayer> getLayer(String layerName) {
        return Optional.ofNullable(this.layers.get(layerName));
    }

    @Deprecated
    @Nullable
    public TileLayer getTileLayer(String layerName) {
        return this.getLayer(layerName).orElse(null);
    }

    @Deprecated
    @Nullable
    public TileLayer getTileLayerById(String layerId) {
        return this.layers.get(layerId);
    }

    @Override
    public boolean containsLayer(String layerId) {
        return this.layers.containsKey(layerId);
    }

    @Override
    public int getLayerCount() {
        return this.layers.size();
    }

    @Override
    public Set<String> getLayerNames() {
        return Collections.unmodifiableSet(this.layers.keySet());
    }

    @Override
    public String getVersion() {
        return this.getGwcConfig().getVersion();
    }

    @Override
    public Boolean isFullWMS() {
        if (this.getGwcConfig() != null) {
            return this.getGwcConfig().getFullWMS();
        }
        return null;
    }

    @Override
    public void setFullWMS(Boolean isFullWMS) throws IOException {
        this.getGwcConfig().setFullWMS(isFullWMS);
        this.save();
    }

    @Override
    public List<BlobStoreInfo> getBlobStores() {
        return Collections.unmodifiableList(this.getGwcConfig().getBlobStores().stream().map(info -> (BlobStoreInfo)info.clone()).collect(Collectors.toList()));
    }

    @Override
    public synchronized void addBlobStore(BlobStoreInfo info) {
        if (info.getName() == null) {
            throw new IllegalArgumentException("Failed to add BlobStoreInfo. A BlobStoreInfo name cannot be null");
        }
        if (this.getBlobStoreNames().contains(info.getName())) {
            throw new IllegalArgumentException(String.format("Failed to add BlobStoreInfo. A BlobStoreInfo with name \"%s\" already exists", info.getName()));
        }
        List<BlobStoreInfo> blobStores = this.getGwcConfig().getBlobStores();
        blobStores.add(info);
        try {
            this.save();
        }
        catch (IOException ioe) {
            blobStores.remove(info);
            throw new ConfigurationPersistenceException(String.format("Unable to add BlobStoreInfo \"%s\"", info), ioe);
        }
        try {
            this.blobStoreListeners.safeForEach(listener -> listener.handleAddBlobStore(info));
        }
        catch (IOException | GeoWebCacheException e) {
            if (ExceptionUtils.isOrSuppresses(e, UnsuitableStorageException.class)) {
                blobStores.remove(info);
                throw new ConfigurationPersistenceException(String.format("Unable to add BlobStoreInfo \"%s\"", info), e);
            }
            throw new ConfigurationPersistenceException(e);
        }
    }

    @Override
    public synchronized void removeBlobStore(String name) {
        BlobStoreInfo infoToRemove = this.getBlobStore(name).orElseThrow(() -> new NoSuchElementException(String.format("Failed to remove BlobStoreInfo. A BlobStoreInfo with name \"%s\" does not exist.", name)));
        List<BlobStoreInfo> blobStores = this.getGwcConfig().getBlobStores();
        blobStores.remove(infoToRemove);
        try {
            this.save();
        }
        catch (IOException ioe) {
            blobStores.add(infoToRemove);
            throw new ConfigurationPersistenceException(String.format("Unable to remove BlobStoreInfo \"%s\"", name), ioe);
        }
        try {
            this.blobStoreListeners.safeForEach(listener -> listener.handleRemoveBlobStore(infoToRemove));
        }
        catch (IOException | GeoWebCacheException e) {
            throw new ConfigurationPersistenceException(e);
        }
    }

    @Override
    public synchronized void modifyBlobStore(BlobStoreInfo info) {
        if (info.getName() == null) {
            throw new IllegalArgumentException("BlobStoreInfo name must not be null");
        }
        Optional<BlobStoreInfo> optionalInfo = this.getBlobStore(info.getName());
        if (!optionalInfo.isPresent()) {
            throw new NoSuchElementException(String.format("Failed to modify BlobStoreInfo. A BlobStoreInfo with name \"%s\" does not exist.", info.getName()));
        }
        List<BlobStoreInfo> blobStores = this.getGwcConfig().getBlobStores();
        BlobStoreInfo infoToRemove = optionalInfo.get();
        blobStores.remove(infoToRemove);
        blobStores.add(info);
        try {
            this.save();
        }
        catch (IOException ioe) {
            blobStores.remove(info);
            blobStores.add(infoToRemove);
            throw new ConfigurationPersistenceException(String.format("Unable to modify BlobStoreInfo \"%s\"", info.getName()), ioe);
        }
        try {
            this.blobStoreListeners.safeForEach(listener -> listener.handleModifyBlobStore(info));
        }
        catch (IOException | GeoWebCacheException e) {
            if (ExceptionUtils.isOrSuppresses(e, UnsuitableStorageException.class)) {
                blobStores.remove(info);
                blobStores.add(infoToRemove);
                throw new ConfigurationPersistenceException(String.format("Unable to modify BlobStoreInfo \"%s\"", info), e);
            }
            throw new ConfigurationPersistenceException(e);
        }
    }

    @Override
    public int getBlobStoreCount() {
        return this.getGwcConfig().getBlobStores().size();
    }

    @Override
    public Set<String> getBlobStoreNames() {
        return this.getGwcConfig().getBlobStores().stream().map(info -> info.getName()).collect(Collectors.toSet());
    }

    @Override
    public Optional<BlobStoreInfo> getBlobStore(String name) {
        for (BlobStoreInfo info : this.getGwcConfig().getBlobStores()) {
            if (!info.getName().equals(name)) continue;
            return Optional.of((BlobStoreInfo)info.clone());
        }
        return Optional.empty();
    }

    @Override
    public boolean canSave(BlobStoreInfo info) {
        return this.resourceProvider.hasOutput();
    }

    @Override
    public void renameBlobStore(String oldName, String newName) throws NoSuchElementException, IllegalArgumentException {
        Optional<BlobStoreInfo> newInfo = this.getBlobStore(newName);
        if (newInfo.isPresent()) {
            throw new IllegalArgumentException("BlobStoreInfo rename unsuccessful. A BlobStoreInfo with name \"" + newName + "\" already exists.");
        }
        List<BlobStoreInfo> blobStoreInfos = this.getGwcConfig().getBlobStores();
        Iterator<BlobStoreInfo> infos = blobStoreInfos.iterator();
        BlobStoreInfo foundInfo = null;
        while (infos.hasNext() && foundInfo == null) {
            BlobStoreInfo info = infos.next();
            if (!info.getName().equals(oldName)) continue;
            infos.remove();
            foundInfo = info;
        }
        BlobStoreInfo blobStoreInfoToRename = foundInfo;
        if (blobStoreInfoToRename == null) {
            throw new NoSuchElementException("BlobStoreInfo rename unsuccessful. No BlobStoreInfo with name \"" + oldName + "\" exists.");
        }
        blobStoreInfoToRename.setName(newName);
        blobStoreInfos.add(blobStoreInfoToRename);
        try {
            this.save();
            if (log.isLoggable(Level.FINER)) {
                log.finer(String.format("BlobStoreInfo rename from \"%s\" to \"%s\" successful.", oldName, newName));
            }
        }
        catch (IOException ioe) {
            infos = blobStoreInfos.iterator();
            BlobStoreInfo blobStoreInfoToRevert = null;
            while (infos.hasNext() && blobStoreInfoToRevert == null) {
                BlobStoreInfo info = infos.next();
                if (!info.getName().equals(newName)) continue;
                infos.remove();
                blobStoreInfoToRevert = info;
            }
            if (blobStoreInfoToRevert == null) {
                throw new ConfigurationPersistenceException(String.format("Error reverting BlobStoreInfo modification. Could not revert rename from \"%s\" to \"%s\"", oldName, newName));
            }
            blobStoreInfoToRevert.setName(oldName);
            blobStoreInfos.add(blobStoreInfoToRevert);
            throw new ConfigurationPersistenceException(String.format("Unable to rename BlobStoreInfo from \"%s\" to \"%s\"", oldName, newName), ioe);
        }
        try {
            this.blobStoreListeners.safeForEach(listener -> listener.handleRenameBlobStore(oldName, blobStoreInfoToRename));
        }
        catch (IOException | GeoWebCacheException e) {
            throw new ConfigurationPersistenceException(String.format("Exception while handling listeners for renaming blobstore \"%s\" to \"%s\"", oldName, newName), e);
        }
    }

    @Override
    public boolean containsBlobStore(String name) {
        if (name != null) {
            return this.getBlobStore(name).isPresent();
        }
        return false;
    }

    @Override
    public void addBlobStoreListener(BlobStoreConfigurationListener listener) {
        this.blobStoreListeners.add(listener);
    }

    @Override
    public void removeBlobStoreListener(BlobStoreConfigurationListener listener) {
        this.blobStoreListeners.remove(listener);
    }

    @Override
    public LockProvider getLockProvider() {
        return this.getGwcConfig().getLockProvider();
    }

    @Override
    public void setLockProvider(LockProvider lockProvider) throws IOException {
        this.getGwcConfig().setLockProvider(lockProvider);
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GeoWebCacheConfiguration getGwcConfig() {
        block6: {
            try {
                if (this.gwcConfig != null) break block6;
                XMLConfiguration xMLConfiguration = this;
                synchronized (xMLConfiguration) {
                    if (this.gwcConfig == null) {
                        this.gwcConfig = this.loadConfiguration();
                    }
                }
            }
            catch (ConfigurationException e) {
                throw new IllegalStateException("Configuration " + this.getIdentifier() + " is not fully initialized and lazy initialization failed", e);
            }
        }
        return this.gwcConfig;
    }

    private void setGwcConfig(GeoWebCacheConfiguration gwcConfig) {
        this.gwcConfig = gwcConfig;
    }

    @Override
    public Boolean isWmtsCiteCompliant() {
        if (this.gwcConfig == null) {
            return false;
        }
        return this.gwcConfig.isWmtsCiteCompliant();
    }

    @Override
    public void setWmtsCiteCompliant(Boolean wmtsCiteStrictCompliant) throws IOException {
        if (this.gwcConfig != null) {
            this.gwcConfig.setWmtsCiteCompliant(wmtsCiteStrictCompliant);
        }
        this.save();
    }

    @Override
    public Integer getBackendTimeout() {
        return this.gwcConfig.getBackendTimeout();
    }

    @Override
    public void setBackendTimeout(Integer backendTimeout) throws IOException {
        this.gwcConfig.setBackendTimeout(backendTimeout);
        this.save();
    }

    @Override
    public Boolean isCacheBypassAllowed() {
        return this.gwcConfig.getCacheBypassAllowed();
    }

    @Override
    public void setCacheBypassAllowed(Boolean cacheBypassAllowed) throws IOException {
        this.gwcConfig.setCacheBypassAllowed(cacheBypassAllowed);
        this.save();
    }

    @Override
    public String getLocation() {
        try {
            return this.resourceProvider.getLocation();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Could not get config location", e);
            return "Error, see log for details";
        }
    }

    @Override
    public synchronized void addGridSet(GridSet gridSet) {
        this.validateGridSet(gridSet);
        GridSet old = this.getGridSetsInternal().get(gridSet.getName());
        if (old != null) {
            throw new IllegalArgumentException("GridSet " + gridSet.getName() + " already exists");
        }
        assert (this.getGwcConfig().getGridSets().stream().noneMatch(xgs -> xgs.getName().equals(gridSet.getName())));
        try {
            this.saveGridSet(gridSet);
        }
        catch (IOException e) {
            throw new ConfigurationPersistenceException(e);
        }
        this.getGridSetsInternal().put(gridSet.getName(), gridSet);
    }

    private void validateGridSet(GridSet gridSet) {
        if (Objects.isNull(gridSet.getName())) {
            throw new IllegalArgumentException("GridSet name is not set");
        }
        if (gridSet.getNumLevels() == 0) {
            throw new IllegalArgumentException("GridSet has no levels");
        }
    }

    private void saveGridSet(GridSet gridSet) throws IOException {
        this.addOrReplaceGridSet(new XMLGridSet(gridSet));
        this.save();
    }

    @Override
    public synchronized void removeGridSet(String gridSetName) {
        GridSet gsRemoved = this.getGridSetsInternal().remove(gridSetName);
        XMLGridSet xgsRemoved = null;
        Iterator<XMLGridSet> it = this.getGwcConfig().getGridSets().iterator();
        while (it.hasNext()) {
            XMLGridSet xgs = it.next();
            if (!gridSetName.equals(xgs.getName())) continue;
            it.remove();
            xgsRemoved = xgs;
            break;
        }
        assert (Objects.isNull(gsRemoved) == Objects.isNull(xgsRemoved));
        if (Objects.isNull(gsRemoved)) {
            throw new NoSuchElementException("Could not remeove GridSet " + gridSetName + " as it does not exist");
        }
        try {
            this.save();
        }
        catch (IOException ex) {
            this.getGridSetsInternal().put(gridSetName, gsRemoved);
            this.getGwcConfig().getGridSets().add(xgsRemoved);
            throw new ConfigurationPersistenceException("Could not persist removal of Gridset " + gridSetName, ex);
        }
    }

    @Override
    public Optional<GridSet> getGridSet(String name) {
        return Optional.ofNullable(this.getGridSetsInternal().get(name)).map(GridSet::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, GridSet> getGridSetsInternal() {
        if (this.gridSets == null) {
            XMLConfiguration xMLConfiguration = this;
            synchronized (xMLConfiguration) {
                if (this.gridSets == null) {
                    this.loadGridSets();
                }
            }
        }
        return this.gridSets;
    }

    @Override
    public Collection<GridSet> getGridSets() {
        return this.getGridSetsInternal().values().stream().map(GridSet::new).collect(Collectors.toList());
    }

    @Override
    public synchronized void modifyGridSet(GridSet gridSet) throws NoSuchElementException, IllegalArgumentException, UnsupportedOperationException {
        this.validateGridSet(gridSet);
        GridSet old = this.getGridSetsInternal().get(gridSet.getName());
        if (old == null) {
            throw new NoSuchElementException("GridSet " + gridSet.getName() + " does not exist");
        }
        assert (this.getGwcConfig().getGridSets().stream().anyMatch(xgs -> xgs.getName().equals(gridSet.getName())));
        try {
            this.saveGridSet(gridSet);
        }
        catch (IOException e) {
            throw new ConfigurationPersistenceException(e);
        }
        this.getGridSetsInternal().put(gridSet.getName(), gridSet);
    }

    @Override
    public void renameGridSet(String oldName, String newName) throws NoSuchElementException, IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canSave(GridSet gridset) {
        try {
            this.validateGridSet(gridset);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    @Override
    @Autowired
    public void setGridSetBroker(@Qualifier(value="gwcGridSetBroker") GridSetBroker broker) {
        this.gridSetBroker = broker;
    }

    @Override
    public void deinitialize() throws Exception {
        this.gridSets = null;
        this.layers = null;
        this.gwcConfig = null;
    }
}

