/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.junit.rules.ExternalResource;

public abstract class SetSingletonRule<T>
extends ExternalResource {
    T oldValue;
    Supplier<T> newValue;

    protected void setNewValue(Supplier<T> newValue) {
        this.newValue = newValue;
    }

    public SetSingletonRule(@Nullable Supplier<T> newValue) {
        this.newValue = newValue;
    }

    public SetSingletonRule() {
        this(null);
    }

    public static <T> SetSingletonRule<T> create(final Supplier<T> get, final Consumer<T> set, @Nullable Supplier<T> newValue) {
        return new SetSingletonRule<T>(newValue){

            @Override
            public void setValue(T value) {
                set.accept(value);
            }

            @Override
            public T getValue() {
                return get.get();
            }
        };
    }

    public static <T> SetSingletonRule<T> create(Supplier<T> get, Consumer<T> set) {
        return SetSingletonRule.create(get, set, null);
    }

    protected void before() throws Throwable {
        this.oldValue = this.getValue();
        this.init();
    }

    protected void after() {
        this.setValue(this.oldValue);
    }

    public abstract void setValue(T var1);

    protected void init() {
        if (Objects.nonNull(this.newValue)) {
            this.setValue(this.newValue.get());
        }
    }

    public abstract T getValue();

    public T getOldValue() {
        return this.oldValue;
    }
}

